#
# (C) Tenable Network Security
#
#
# The text of this plugin is (C) Red Hat Inc.

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(25988);
 script_version ("$Revision: 1.2 $");
 script_cve_id("CVE-2007-4134");

 name["english"] = "RHSA-2007-0873: star";
 
 script_name(english:name["english"]);
 
 desc["english"] = '

  An updated star package that fixes a path traversal flaw is now available.

  This update has been rated as having moderate security impact by the Red
  Hat Security Response Team.

  Star is a tar-like archiver. It saves multiple files into a single tape or
  disk archive, and can restore individual files from the archive. Star
  includes multi-volume support, automatic archive format detection and ACL
  support.

  A path traversal flaw was discovered in the way star extracted archives. A
  malicious user could create a tar archive that would cause star to write to
  arbitrary files to which the user running star had write access.
  (CVE-2007-4134)

  Red Hat would like to thank Robert Buchholz for reporting this issue.

  As well, this update adds the command line argument "-.." to the Red Hat
  Enterprise Linux 3 version of star. This allows star to extract files
  containing "/../" in their pathname.

  Users of star should upgrade to this updated package, which contain
  backported patches to correct these issues.




Solution : http://rhn.redhat.com/errata/RHSA-2007-0873.html
Risk factor : High';

 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the star packages";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"star-1.5a75-2", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"star-1.5a08-5", release:"RHEL3") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"star-1.5a25-8", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"star-1.5a75-2", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"star-1.5a08-5", release:"RHEL3") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"star-1.5a25-8", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"star-1.5a08-5", release:"RHEL3") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"star-1.5a25-8", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}

if ( rpm_exists(rpm:"star-", release:"RHEL5") )
{
 set_kb_item(name:"CVE-2007-4134", value:TRUE);
}
if ( rpm_exists(rpm:"star-", release:"RHEL3") )
{
 set_kb_item(name:"CVE-2007-4134", value:TRUE);
}
if ( rpm_exists(rpm:"star-", release:"RHEL4") )
{
 set_kb_item(name:"CVE-2007-4134", value:TRUE);
}
if ( rpm_exists(rpm:"star-", release:"RHEL5") )
{
 set_kb_item(name:"CVE-2007-4134", value:TRUE);
}
if ( rpm_exists(rpm:"star-", release:"RHEL3") )
{
 set_kb_item(name:"CVE-2007-4134", value:TRUE);
}
if ( rpm_exists(rpm:"star-", release:"RHEL4") )
{
 set_kb_item(name:"CVE-2007-4134", value:TRUE);
}
if ( rpm_exists(rpm:"star-", release:"RHEL3") )
{
 set_kb_item(name:"CVE-2007-4134", value:TRUE);
}
if ( rpm_exists(rpm:"star-", release:"RHEL4") )
{
 set_kb_item(name:"CVE-2007-4134", value:TRUE);
}

set_kb_item(name:"RHSA-2007-0873", value:TRUE);
