#
# (C) Tenable Network Security
#
#
# The text of this plugin is (C) Red Hat Inc.

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(26051);
 script_version ("$Revision: 1.2 $");
 script_cve_id("CVE-2007-0242", "CVE-2007-4137");

 name["english"] = "RHSA-2007-0883: qt";
 
 script_name(english:name["english"]);
 
 desc["english"] = '

  Updated qt packages that correct two security flaws are now available.

  This update has been rated as having important security impact by the Red
  Hat Security Response Team.

  Qt is a software toolkit that simplifies the task of writing and
  maintaining GUI (Graphical User Interface) applications for the X Window
  System.

  A flaw was found in the way Qt expanded certain UTF8 characters. It was
  possible to prevent a Qt-based application from properly sanitizing user
  supplied input. This could, for example, result in a cross-site scripting
  attack against the Konqueror web browser. (CVE-2007-0242)

  A buffer overflow flaw was found in the way Qt expanded malformed Unicode
  strings. If an application linked against Qt parsed a malicious Unicode
  string, it could lead to a denial of service or possibly allow the
  execution of arbitrary code. (CVE-2007-4137)

  Users of Qt should upgrade to these updated packages, which contain a
  backported patch to correct these issues.




Solution : http://rhn.redhat.com/errata/RHSA-2007-0883.html
Risk factor : High';

 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the qt packages";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"qt-3.3.6-23.el5", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"qt-MySQL-3.3.6-23.el5", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"qt-ODBC-3.3.6-23.el5", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"qt-PostgreSQL-3.3.6-23.el5", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"qt-config-3.3.6-23.el5", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"qt-designer-3.3.6-23.el5", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"qt-devel-3.3.6-23.el5", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"qt-devel-docs-3.3.6-23.el5", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"qt-2.3.1-14.EL2", release:"RHEL2.1") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"qt-Xt-2.3.1-14.EL2", release:"RHEL2.1") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"qt-designer-2.3.1-14.EL2", release:"RHEL2.1") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"qt-devel-2.3.1-14.EL2", release:"RHEL2.1") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"qt-static-2.3.1-14.EL2", release:"RHEL2.1") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"qt-3.1.2-17.RHEL3", release:"RHEL3") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"qt-MySQL-3.1.2-17.RHEL3", release:"RHEL3") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"qt-ODBC-3.1.2-17.RHEL3", release:"RHEL3") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"qt-config-3.1.2-17.RHEL3", release:"RHEL3") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"qt-designer-3.1.2-17.RHEL3", release:"RHEL3") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"qt-devel-3.1.2-17.RHEL3", release:"RHEL3") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"qt-3.3.3-13.RHEL4", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"qt-MySQL-3.3.3-13.RHEL4", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"qt-ODBC-3.3.3-13.RHEL4", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"qt-PostgreSQL-3.3.3-13.RHEL4", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"qt-config-3.3.3-13.RHEL4", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"qt-designer-3.3.3-13.RHEL4", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"qt-devel-3.3.3-13.RHEL4", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"qt-3.3.6-23.el5", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"qt-MySQL-3.3.6-23.el5", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"qt-ODBC-3.3.6-23.el5", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"qt-PostgreSQL-3.3.6-23.el5", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"qt-config-3.3.6-23.el5", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"qt-2.3.1-14.EL2", release:"RHEL2.1") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"qt-Xt-2.3.1-14.EL2", release:"RHEL2.1") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"qt-designer-2.3.1-14.EL2", release:"RHEL2.1") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"qt-devel-2.3.1-14.EL2", release:"RHEL2.1") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"qt-static-2.3.1-14.EL2", release:"RHEL2.1") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"qt-3.3.3-13.RHEL4", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"qt-MySQL-3.3.3-13.RHEL4", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"qt-ODBC-3.3.3-13.RHEL4", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"qt-PostgreSQL-3.3.3-13.RHEL4", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"qt-config-3.3.3-13.RHEL4", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"qt-designer-3.3.3-13.RHEL4", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"qt-devel-3.3.3-13.RHEL4", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"qt-2.3.1-14.EL2", release:"RHEL2.1") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"qt-Xt-2.3.1-14.EL2", release:"RHEL2.1") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"qt-designer-2.3.1-14.EL2", release:"RHEL2.1") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"qt-devel-2.3.1-14.EL2", release:"RHEL2.1") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"qt-static-2.3.1-14.EL2", release:"RHEL2.1") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"qt-3.3.3-13.RHEL4", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"qt-MySQL-3.3.3-13.RHEL4", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"qt-ODBC-3.3.3-13.RHEL4", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"qt-PostgreSQL-3.3.3-13.RHEL4", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"qt-config-3.3.3-13.RHEL4", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"qt-designer-3.3.3-13.RHEL4", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"qt-devel-3.3.3-13.RHEL4", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}

if ( rpm_exists(rpm:"qt-", release:"RHEL5") )
{
 set_kb_item(name:"CVE-2007-0242", value:TRUE);
 set_kb_item(name:"CVE-2007-4137", value:TRUE);
}
if ( rpm_exists(rpm:"qt-", release:"RHEL2.1") )
{
 set_kb_item(name:"CVE-2007-0242", value:TRUE);
 set_kb_item(name:"CVE-2007-4137", value:TRUE);
}
if ( rpm_exists(rpm:"qt-", release:"RHEL3") )
{
 set_kb_item(name:"CVE-2007-0242", value:TRUE);
 set_kb_item(name:"CVE-2007-4137", value:TRUE);
}
if ( rpm_exists(rpm:"qt-", release:"RHEL4") )
{
 set_kb_item(name:"CVE-2007-0242", value:TRUE);
 set_kb_item(name:"CVE-2007-4137", value:TRUE);
}
if ( rpm_exists(rpm:"qt-", release:"RHEL5") )
{
 set_kb_item(name:"CVE-2007-0242", value:TRUE);
 set_kb_item(name:"CVE-2007-4137", value:TRUE);
}
if ( rpm_exists(rpm:"qt-", release:"RHEL2.1") )
{
 set_kb_item(name:"CVE-2007-0242", value:TRUE);
 set_kb_item(name:"CVE-2007-4137", value:TRUE);
}
if ( rpm_exists(rpm:"qt-", release:"RHEL4") )
{
 set_kb_item(name:"CVE-2007-0242", value:TRUE);
 set_kb_item(name:"CVE-2007-4137", value:TRUE);
}
if ( rpm_exists(rpm:"qt-", release:"RHEL2.1") )
{
 set_kb_item(name:"CVE-2007-0242", value:TRUE);
 set_kb_item(name:"CVE-2007-4137", value:TRUE);
}
if ( rpm_exists(rpm:"qt-", release:"RHEL4") )
{
 set_kb_item(name:"CVE-2007-0242", value:TRUE);
 set_kb_item(name:"CVE-2007-4137", value:TRUE);
}

set_kb_item(name:"RHSA-2007-0883", value:TRUE);
