#
# (C) Tenable Network Security
#
#
# The text of this plugin is (C) Red Hat Inc.

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(26953);
 script_version ("$Revision: 1.2 $");
 script_cve_id("CVE-2007-4897");

 name["english"] = "RHSA-2007-0932: pwlib";
 
 script_name(english:name["english"]);
 
 desc["english"] = '

  Updated pwlib packages that fix a security issue are now available for Red
  Hat Enterprise Linux 5.

  This update has been rated as having moderate security impact by the Red
  Hat Security Response Team.

  PWLib is a library used to support cross-platform applications.

  In Red Hat Enterprise Linux 5, the Ekiga teleconferencing application uses
  PWLib.

  A memory management flaw was discovered in PWLib. An attacker could use this
  flaw to crash an application, such as Ekiga, which is linked with pwlib
  (CVE-2007-4897).

  Users should upgrade to these updated packages which contain a backported
  patch to correct this issue.




Solution : http://rhn.redhat.com/errata/RHSA-2007-0932.html
Risk factor : High';

 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the pwlib packages";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"pwlib-1.10.1-7.0.1.el5", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}

if ( rpm_exists(rpm:"pwlib-", release:"RHEL5") )
{
 set_kb_item(name:"CVE-2007-4897", value:TRUE);
}

set_kb_item(name:"RHSA-2007-0932", value:TRUE);
