#
# (C) Tenable Network Security
#
#
# The text of this plugin is (C) Red Hat Inc.

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(26954);
 script_version ("$Revision: 1.2 $");
 script_cve_id("CVE-2007-5034");

 name["english"] = "RHSA-2007-0933: elinks";
 
 script_name(english:name["english"]);
 
 desc["english"] = '

  An updated ELinks package that corrects a security vulnerability is now
  available for Red Hat Enterprise Linux 4 and 5.

  This update has been rated as having moderate security impact by the Red
  Hat Security Response Team.

  ELinks is a text mode Web browser used from the command line that supports
  rendering modern web pages.

  An information disclosure flaw was found in the way ELinks passes https
  POST data to a proxy server. POST data sent via a proxy to an https site is
  not properly encrypted by ELinks, possibly allowing the disclosure of
  sensitive information. (CVE-2007-5034)

  All users of Elinks are advised to upgrade to this updated package, which
  contains a backported patch that resolves this issue.




Solution : http://rhn.redhat.com/errata/RHSA-2007-0933.html
Risk factor : High';

 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the elinks packages";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"elinks-0.11.1-5.1.0.1.el5", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"elinks-0.9.2-3.3.5.2", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"elinks-0.11.1-5.1.0.1.el5", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"elinks-0.9.2-3.3.5.2", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"elinks-0.9.2-3.3.5.2", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}

if ( rpm_exists(rpm:"elinks-", release:"RHEL5") )
{
 set_kb_item(name:"CVE-2007-5034", value:TRUE);
}
if ( rpm_exists(rpm:"elinks-", release:"RHEL4") )
{
 set_kb_item(name:"CVE-2007-5034", value:TRUE);
}
if ( rpm_exists(rpm:"elinks-", release:"RHEL5") )
{
 set_kb_item(name:"CVE-2007-5034", value:TRUE);
}
if ( rpm_exists(rpm:"elinks-", release:"RHEL4") )
{
 set_kb_item(name:"CVE-2007-5034", value:TRUE);
}
if ( rpm_exists(rpm:"elinks-", release:"RHEL4") )
{
 set_kb_item(name:"CVE-2007-5034", value:TRUE);
}

set_kb_item(name:"RHSA-2007-0933", value:TRUE);
