#
# (C) Tenable Network Security
#
#
# The text of this plugin is (C) Red Hat Inc.

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(26955);
 script_version ("$Revision: 1.2 $");
 script_cve_id("CVE-2007-4924");

 name["english"] = "RHSA-2007-0957: opal";
 
 script_name(english:name["english"]);
 
 desc["english"] = '

  Updated opal packages that fix a security issue are now available for Red
  Hat Enterprise Linux 5.

  This update has been rated as having moderate security impact by the Red
  Hat Security Response Team.

  Open Phone Abstraction Library (opal) is implementation of various
  telephony and video communication protocols for use over packet based
  networks.

  In Red Hat Enterprise Linux 5, the Ekiga application uses opal.

  A flaw was discovered in the way opal handled certain Session Initiation
  Protocol (SIP) packets. An attacker could use this flaw to crash an
  application, such as Ekiga, which is linked with opal. (CVE-2007-4924)

  Users should upgrade to these updated opal packages which contain a
  backported patch to correct this issue.




Solution : http://rhn.redhat.com/errata/RHSA-2007-0957.html
Risk factor : High';

 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the opal packages";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"opal-2.2.2-1.1.0.1", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}

if ( rpm_exists(rpm:"opal-", release:"RHEL5") )
{
 set_kb_item(name:"CVE-2007-4924", value:TRUE);
}

set_kb_item(name:"RHSA-2007-0957", value:TRUE);
