#
# (C) Tenable Network Security
#
#
# The text of this plugin is (C) Red Hat Inc.

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(28202);
 script_version ("$Revision: 1.1 $");
 script_cve_id("CVE-2007-5162", "CVE-2007-5770");

 name["english"] = "RHSA-2007-0965: ruby";
 
 script_name(english:name["english"]);
 
 desc["english"] = '

  Updated ruby packages that fix several security issues are now available
  for Red Hat Enterprise Linux 5.

  This update has been rated as having moderate security impact by the Red
  Hat Security Response Team.

  Ruby is an interpreted scripting language for object-oriented programming.

  An SSL certificate validation flaw was discovered in several Ruby Net
  modules. The libraries were not checking the requested host name against
  the common name (CN) in the SSL server certificate, possibly allowing a man
  in the middle attack. (CVE-2007-5162, CVE-2007-5770)

  Users of Ruby should upgrade to these updated packages, which contain a
  backported patch to resolve these issues.




Solution : http://rhn.redhat.com/errata/RHSA-2007-0965.html
Risk factor : High';

 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the ruby packages";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"ruby-1.8.5-5.el5_1.1", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"ruby-devel-1.8.5-5.el5_1.1", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"ruby-docs-1.8.5-5.el5_1.1", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"ruby-irb-1.8.5-5.el5_1.1", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"ruby-libs-1.8.5-5.el5_1.1", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"ruby-mode-1.8.5-5.el5_1.1", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"ruby-rdoc-1.8.5-5.el5_1.1", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"ruby-ri-1.8.5-5.el5_1.1", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"ruby-tcltk-1.8.5-5.el5_1.1", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"ruby-1.8.5-5.el5_1.1", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"ruby-docs-1.8.5-5.el5_1.1", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"ruby-irb-1.8.5-5.el5_1.1", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"ruby-libs-1.8.5-5.el5_1.1", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"ruby-rdoc-1.8.5-5.el5_1.1", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"ruby-ri-1.8.5-5.el5_1.1", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"ruby-tcltk-1.8.5-5.el5_1.1", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}

if ( rpm_exists(rpm:"ruby-", release:"RHEL5") )
{
 set_kb_item(name:"CVE-2007-5162", value:TRUE);
 set_kb_item(name:"CVE-2007-5770", value:TRUE);
}
if ( rpm_exists(rpm:"ruby-", release:"RHEL5") )
{
 set_kb_item(name:"CVE-2007-5162", value:TRUE);
 set_kb_item(name:"CVE-2007-5770", value:TRUE);
}

set_kb_item(name:"RHSA-2007-0965", value:TRUE);
