#
# (C) Tenable Network Security
#
#
# The text of this plugin is (C) Red Hat Inc.

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(27566);
 script_version ("$Revision: 1.1 $");
 script_cve_id("CVE-2007-5365");

 name["english"] = "RHSA-2007-0970: dhcp";
 
 script_name(english:name["english"]);
 
 desc["english"] = '

  An updated dhcp package that corrects a security flaw is now available for
  Red Hat Enterprise Linux 2.1.

  This update has been rated as having important security impact by the Red
  Hat Security Response Team.

  The dhcp package provides the ISC Dynamic Host Configuration Protocol
  (DHCP) server and relay agent, dhcpd. DHCP is a protocol that allows
  devices to get their own network configuration information from a server.

  A bug was found in the way dhcpd validates certain DHCP protocol options.
  A malicious DHCP client could send a carefully crafted DHCP request and
  cause
  dhcpd to crash or possibly execute arbitrary code. (CVE-2007-5365)

  All users of dhcp should upgrade to this updated package, which contains a
  backported patch that resolves this issue.




Solution : http://rhn.redhat.com/errata/RHSA-2007-0970.html
Risk factor : High';

 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the dhcp packages";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"dhcp-2.0pl5-11", release:"RHEL2.1") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"dhcp-2.0pl5-11", release:"RHEL2.1") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}

if ( rpm_exists(rpm:"dhcp-", release:"RHEL2.1") )
{
 set_kb_item(name:"CVE-2007-5365", value:TRUE);
}
if ( rpm_exists(rpm:"dhcp-", release:"RHEL2.1") )
{
 set_kb_item(name:"CVE-2007-5365", value:TRUE);
}

set_kb_item(name:"RHSA-2007-0970", value:TRUE);
