#
# (C) Tenable Network Security
#
#
# The text of this plugin is (C) Red Hat Inc.

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(27568);
 script_version ("$Revision: 1.1 $");
 script_cve_id("CVE-2007-1095", "CVE-2007-2292", "CVE-2007-3511", "CVE-2007-3844", "CVE-2007-5334", "CVE-2007-5337", "CVE-2007-5338", "CVE-2007-5339", "CVE-2007-5340");

 name["english"] = "RHSA-2007-0979: firefox";
 
 script_name(english:name["english"]);
 
 desc["english"] = '

  Updated firefox packages that fix several security bugs are now available
  for Red Hat Enterprise Linux 4 and 5.

  This update has been rated as having critical security impact by the Red
  Hat Security Response Team.

  Mozilla Firefox is an open source Web browser.

  Several flaws were found in the way in which Firefox processed certain
  malformed web content. A web page containing malicious content could cause
  Firefox to crash or potentially execute arbitrary code as the user running
  Firefox. (CVE-2007-5338, CVE-2007-5339, CVE-2007-5340)

  Several flaws were found in the way in which Firefox displayed malformed
  web content. A web page containing specially-crafted content could
  potentially trick a user into surrendering sensitive information.
  (CVE-2007-1095, CVE-2007-3844, CVE-2007-3511, CVE-2007-5334)

  A flaw was found in the Firefox sftp protocol handler. A malicious web page
  could access data from a remote sftp site, possibly stealing sensitive user
  data. (CVE-2007-5337)

  A request-splitting flaw was found in the way in which Firefox generates a
  digest authentication request. If a user opened a specially-crafted URL, it
  was possible to perform cross-site scripting attacks, web cache poisoning,
  or other, similar exploits. (CVE-2007-2292)

  All users of Firefox are advised to upgrade to these updated packages,
  which contain backported patches that correct these issues.




Solution : http://rhn.redhat.com/errata/RHSA-2007-0979.html
Risk factor : High';

 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the firefox packages";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"firefox-1.5.0.12-6.el5", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"firefox-devel-1.5.0.12-6.el5", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"firefox-1.5.0.12-0.7.el4", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"firefox-1.5.0.12-6.el5", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"firefox-1.5.0.12-0.7.el4", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"firefox-1.5.0.12-0.7.el4", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}

if ( rpm_exists(rpm:"firefox-", release:"RHEL5") )
{
 set_kb_item(name:"CVE-2007-1095", value:TRUE);
 set_kb_item(name:"CVE-2007-2292", value:TRUE);
 set_kb_item(name:"CVE-2007-3511", value:TRUE);
 set_kb_item(name:"CVE-2007-3844", value:TRUE);
 set_kb_item(name:"CVE-2007-5334", value:TRUE);
 set_kb_item(name:"CVE-2007-5337", value:TRUE);
 set_kb_item(name:"CVE-2007-5338", value:TRUE);
 set_kb_item(name:"CVE-2007-5339", value:TRUE);
 set_kb_item(name:"CVE-2007-5340", value:TRUE);
}
if ( rpm_exists(rpm:"firefox-", release:"RHEL4") )
{
 set_kb_item(name:"CVE-2007-1095", value:TRUE);
 set_kb_item(name:"CVE-2007-2292", value:TRUE);
 set_kb_item(name:"CVE-2007-3511", value:TRUE);
 set_kb_item(name:"CVE-2007-3844", value:TRUE);
 set_kb_item(name:"CVE-2007-5334", value:TRUE);
 set_kb_item(name:"CVE-2007-5337", value:TRUE);
 set_kb_item(name:"CVE-2007-5338", value:TRUE);
 set_kb_item(name:"CVE-2007-5339", value:TRUE);
 set_kb_item(name:"CVE-2007-5340", value:TRUE);
}
if ( rpm_exists(rpm:"firefox-", release:"RHEL5") )
{
 set_kb_item(name:"CVE-2007-1095", value:TRUE);
 set_kb_item(name:"CVE-2007-2292", value:TRUE);
 set_kb_item(name:"CVE-2007-3511", value:TRUE);
 set_kb_item(name:"CVE-2007-3844", value:TRUE);
 set_kb_item(name:"CVE-2007-5334", value:TRUE);
 set_kb_item(name:"CVE-2007-5337", value:TRUE);
 set_kb_item(name:"CVE-2007-5338", value:TRUE);
 set_kb_item(name:"CVE-2007-5339", value:TRUE);
 set_kb_item(name:"CVE-2007-5340", value:TRUE);
}
if ( rpm_exists(rpm:"firefox-", release:"RHEL4") )
{
 set_kb_item(name:"CVE-2007-1095", value:TRUE);
 set_kb_item(name:"CVE-2007-2292", value:TRUE);
 set_kb_item(name:"CVE-2007-3511", value:TRUE);
 set_kb_item(name:"CVE-2007-3844", value:TRUE);
 set_kb_item(name:"CVE-2007-5334", value:TRUE);
 set_kb_item(name:"CVE-2007-5337", value:TRUE);
 set_kb_item(name:"CVE-2007-5338", value:TRUE);
 set_kb_item(name:"CVE-2007-5339", value:TRUE);
 set_kb_item(name:"CVE-2007-5340", value:TRUE);
}
if ( rpm_exists(rpm:"firefox-", release:"RHEL4") )
{
 set_kb_item(name:"CVE-2007-1095", value:TRUE);
 set_kb_item(name:"CVE-2007-2292", value:TRUE);
 set_kb_item(name:"CVE-2007-3511", value:TRUE);
 set_kb_item(name:"CVE-2007-3844", value:TRUE);
 set_kb_item(name:"CVE-2007-5334", value:TRUE);
 set_kb_item(name:"CVE-2007-5337", value:TRUE);
 set_kb_item(name:"CVE-2007-5338", value:TRUE);
 set_kb_item(name:"CVE-2007-5339", value:TRUE);
 set_kb_item(name:"CVE-2007-5340", value:TRUE);
}

set_kb_item(name:"RHSA-2007-0979", value:TRUE);
