#
# (C) Tenable Network Security
#
#
# The text of this plugin is (C) Red Hat Inc.

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(27571);
 script_version ("$Revision: 1.1 $");
 script_cve_id("CVE-2007-5269");

 name["english"] = "RHSA-2007-0992: libpng";
 
 script_name(english:name["english"]);
 
 desc["english"] = '

  Updated libpng packages that fix security issues are now available for Red
  Hat Enterprise Linux.

  This update has been rated as having moderate security impact by the Red
  Hat Security Response Team.

  The libpng package contains a library of functions for creating and
  manipulating PNG (Portable Network Graphics) image format files.

  Several flaws were discovered in the way libpng handled various PNG image
  chunks. An attacker could create a carefully crafted PNG image file in
  such a way that it could cause an application linked with libpng to crash
  when the file was manipulated. (CVE-2007-5269)

  Users should update to these updated packages which contain a backported
  patch to correct these issues.




Solution : http://rhn.redhat.com/errata/RHSA-2007-0992.html
Risk factor : High';

 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the libpng packages";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"libpng-1.2.10-7.1.el5_0.1", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"libpng-devel-1.2.10-7.1.el5_0.1", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"libpng-1.0.14-11", release:"RHEL2.1") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"libpng-devel-1.0.14-11", release:"RHEL2.1") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"libpng-1.2.2-28", release:"RHEL3") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"libpng-devel-1.2.2-28", release:"RHEL3") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"libpng10-1.0.13-18", release:"RHEL3") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"libpng10-devel-1.0.13-18", release:"RHEL3") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"libpng-1.2.7-3.el4_5.1", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"libpng-devel-1.2.7-3.el4_5.1", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"libpng10-1.0.16-3.el4_5.1", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"libpng10-devel-1.0.16-3.el4_5.1", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"libpng-1.2.10-7.1.el5_0.1", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"libpng-1.0.14-11", release:"RHEL2.1") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"libpng-devel-1.0.14-11", release:"RHEL2.1") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"libpng-1.2.7-3.el4_5.1", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"libpng-devel-1.2.7-3.el4_5.1", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"libpng10-1.0.16-3.el4_5.1", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"libpng10-devel-1.0.16-3.el4_5.1", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"libpng-1.0.14-11", release:"RHEL2.1") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"libpng-devel-1.0.14-11", release:"RHEL2.1") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"libpng-1.2.7-3.el4_5.1", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"libpng-devel-1.2.7-3.el4_5.1", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"libpng10-1.0.16-3.el4_5.1", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"libpng10-devel-1.0.16-3.el4_5.1", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}

if ( rpm_exists(rpm:"libpng-", release:"RHEL5") )
{
 set_kb_item(name:"CVE-2007-5269", value:TRUE);
}
if ( rpm_exists(rpm:"libpng-", release:"RHEL2.1") )
{
 set_kb_item(name:"CVE-2007-5269", value:TRUE);
}
if ( rpm_exists(rpm:"libpng-", release:"RHEL3") )
{
 set_kb_item(name:"CVE-2007-5269", value:TRUE);
}
if ( rpm_exists(rpm:"libpng-", release:"RHEL4") )
{
 set_kb_item(name:"CVE-2007-5269", value:TRUE);
}
if ( rpm_exists(rpm:"libpng-", release:"RHEL5") )
{
 set_kb_item(name:"CVE-2007-5269", value:TRUE);
}
if ( rpm_exists(rpm:"libpng-", release:"RHEL2.1") )
{
 set_kb_item(name:"CVE-2007-5269", value:TRUE);
}
if ( rpm_exists(rpm:"libpng-", release:"RHEL4") )
{
 set_kb_item(name:"CVE-2007-5269", value:TRUE);
}
if ( rpm_exists(rpm:"libpng-", release:"RHEL2.1") )
{
 set_kb_item(name:"CVE-2007-5269", value:TRUE);
}
if ( rpm_exists(rpm:"libpng-", release:"RHEL4") )
{
 set_kb_item(name:"CVE-2007-5269", value:TRUE);
}

set_kb_item(name:"RHSA-2007-0992", value:TRUE);
