#
# (C) Tenable Network Security
#
#
# The text of this plugin is (C) Red Hat Inc.

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(27836);
 script_version ("$Revision: 1.1 $");
 script_cve_id("CVE-2007-4045", "CVE-2007-4351", "CVE-2007-5393");

 name["english"] = "RHSA-2007-1023: cups";
 
 script_name(english:name["english"]);
 
 desc["english"] = '

  Updated cups packages that fix several security issues are now available
  for Red Hat Enterprise Linux 3.

  This update has been rated as having important security impact by the Red
  Hat Security Response Team.

  The Common UNIX Printing System (CUPS) provides a portable printing layer
  for UNIX(R) operating systems.

  Alin Rad Pop discovered a flaw in the handling of PDF files. An attacker
  could create a malicious PDF file that would cause CUPS to crash or
  potentially execute arbitrary code when printed. (CVE-2007-5393)

  Alin Rad Pop discovered a flaw in in the way CUPS handles certain IPP tags.
  A remote attacker who is able to connect to the IPP TCP port could send a
  malicious request causing the CUPS daemon to crash. (CVE-2007-4351)

  A flaw was found in the way CUPS handled SSL negotiation. A remote attacker
  capable of connecting to the CUPS daemon could cause CUPS to crash.
  (CVE-2007-4045)

  All CUPS users are advised to upgrade to these updated packages, which
  contain backported patches to resolve these issues.




Solution : http://rhn.redhat.com/errata/RHSA-2007-1023.html
Risk factor : High';

 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the cups packages";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"cups-1.1.17-13.3.46", release:"RHEL3") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"cups-devel-1.1.17-13.3.46", release:"RHEL3") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"cups-libs-1.1.17-13.3.46", release:"RHEL3") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"cups-1.1.17-13.3.46", release:"RHEL3") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"cups-devel-1.1.17-13.3.46", release:"RHEL3") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"cups-libs-1.1.17-13.3.46", release:"RHEL3") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"cups-1.1.17-13.3.46", release:"RHEL3") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"cups-devel-1.1.17-13.3.46", release:"RHEL3") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"cups-libs-1.1.17-13.3.46", release:"RHEL3") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}

if ( rpm_exists(rpm:"cups-", release:"RHEL3") )
{
 set_kb_item(name:"CVE-2007-4045", value:TRUE);
 set_kb_item(name:"CVE-2007-4351", value:TRUE);
 set_kb_item(name:"CVE-2007-5393", value:TRUE);
}
if ( rpm_exists(rpm:"cups-", release:"RHEL3") )
{
 set_kb_item(name:"CVE-2007-4045", value:TRUE);
 set_kb_item(name:"CVE-2007-4351", value:TRUE);
 set_kb_item(name:"CVE-2007-5393", value:TRUE);
}
if ( rpm_exists(rpm:"cups-", release:"RHEL3") )
{
 set_kb_item(name:"CVE-2007-4045", value:TRUE);
 set_kb_item(name:"CVE-2007-4351", value:TRUE);
 set_kb_item(name:"CVE-2007-5393", value:TRUE);
}

set_kb_item(name:"RHSA-2007-1023", value:TRUE);
