#
# (C) Tenable Network Security
#
#
# The text of this plugin is (C) Red Hat Inc.

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(29302);
 script_version ("$Revision: 1.1 $");
 script_cve_id("CVE-2006-7228", "CVE-2007-2052");

 name["english"] = "RHSA-2007-1077: python";
 
 script_name(english:name["english"]);
 
 desc["english"] = '

  Updated python packages that fix several security issues are now available
  for Red Hat Enterprise Linux 2.1.

  This update has been rated as having moderate security impact by the Red
  Hat Security Response Team.

  Python is an interpreted, interactive, object-oriented programming
  language.

  An integer overflow flaw was discovered in the way Python\'s pcre module
  handled certain regular expressions. If a Python application used the pcre
  module to compile and execute untrusted regular expressions, it may be
  possible to cause the application to crash, or allow arbitrary code
  execution with the privileges of the Python interpreter. (CVE-2006-7228)

  A flaw was discovered in the strxfrm() function of Python\'s locale module.
  Strings generated by this function were not properly NULL-terminated, which
  could possibly cause disclosure of data stored in the memory of a Python
  application using this function. (CVE-2007-2052)

  Users of Python are advised to upgrade to these updated packages, which
  contain backported patches to resolve these issues.




Solution : http://rhn.redhat.com/errata/RHSA-2007-1077.html
Risk factor : High';

 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the python packages";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"python-1.5.2-43.72.2", release:"RHEL2.1") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"python-devel-1.5.2-43.72.2", release:"RHEL2.1") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"python-docs-1.5.2-43.72.2", release:"RHEL2.1") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"python-tools-1.5.2-43.72.2", release:"RHEL2.1") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"tkinter-1.5.2-43.72.2", release:"RHEL2.1") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"python-1.5.2-43.72.2", release:"RHEL2.1") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"python-devel-1.5.2-43.72.2", release:"RHEL2.1") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"python-docs-1.5.2-43.72.2", release:"RHEL2.1") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"python-tools-1.5.2-43.72.2", release:"RHEL2.1") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"tkinter-1.5.2-43.72.2", release:"RHEL2.1") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}

if ( rpm_exists(rpm:"python-", release:"RHEL2.1") )
{
 set_kb_item(name:"CVE-2006-7228", value:TRUE);
 set_kb_item(name:"CVE-2007-2052", value:TRUE);
}
if ( rpm_exists(rpm:"python-", release:"RHEL2.1") )
{
 set_kb_item(name:"CVE-2006-7228", value:TRUE);
 set_kb_item(name:"CVE-2007-2052", value:TRUE);
}

set_kb_item(name:"RHSA-2007-1077", value:TRUE);
