#
# (C) Tenable Network Security
#
#
# The text of this plugin is (C) Red Hat Inc.

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(29773);
 script_version ("$Revision: 1.1 $");
 script_cve_id("CVE-2007-5947", "CVE-2007-5959", "CVE-2007-5960");

 name["english"] = "RHSA-2007-1083: thunderbird";
 
 script_name(english:name["english"]);
 
 desc["english"] = '

  Updated thunderbird packages that fix several security issues are now
  available for Red Hat Enterprise Linux 4 and 5.

  This update has been rated as having moderate security impact by the Red
  Hat Security Response Team.

  Mozilla Thunderbird is a standalone mail and newsgroup client.

  A cross-site scripting flaw was found in the way Thunderbird handled the
  jar: URI scheme. It may be possible for a malicious HTML mail message to
  leverage this flaw, and conduct a cross-site scripting attack against a
  user running Thunderbird. (CVE-2007-5947)

  Several flaws were found in the way Thunderbird processed certain malformed
  HTML mail content. A HTML mail message containing malicious content could
  cause Thunderbird to crash, or potentially execute arbitrary code as the
  user running Thunderbird. (CVE-2007-5959)

  A race condition existed when Thunderbird set the "window.location"
  property when displaying HTML mail content. This flaw could allow a HTML
  mail message to set an arbitrary Referer header, which may lead to a
  Cross-site Request Forgery (CSRF) attack against websites that rely only on
  the Referer header for protection. (CVE-2007-5960)

  All users of thunderbird are advised to upgrade to these updated packages,
  which contain backported patches to resolve these issues.




Solution : http://rhn.redhat.com/errata/RHSA-2007-1083.html
Risk factor : High';

 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the thunderbird packages";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"thunderbird-1.5.0.12-7.el4", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"thunderbird-1.5.0.12-7.el5", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"thunderbird-1.5.0.12-7.el4", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"thunderbird-1.5.0.12-7.el4", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}

if ( rpm_exists(rpm:"thunderbird-", release:"RHEL4") )
{
 set_kb_item(name:"CVE-2007-5947", value:TRUE);
 set_kb_item(name:"CVE-2007-5959", value:TRUE);
 set_kb_item(name:"CVE-2007-5960", value:TRUE);
}
if ( rpm_exists(rpm:"thunderbird-", release:"RHEL5") )
{
 set_kb_item(name:"CVE-2007-5947", value:TRUE);
 set_kb_item(name:"CVE-2007-5959", value:TRUE);
 set_kb_item(name:"CVE-2007-5960", value:TRUE);
}
if ( rpm_exists(rpm:"thunderbird-", release:"RHEL4") )
{
 set_kb_item(name:"CVE-2007-5947", value:TRUE);
 set_kb_item(name:"CVE-2007-5959", value:TRUE);
 set_kb_item(name:"CVE-2007-5960", value:TRUE);
}
if ( rpm_exists(rpm:"thunderbird-", release:"RHEL4") )
{
 set_kb_item(name:"CVE-2007-5947", value:TRUE);
 set_kb_item(name:"CVE-2007-5959", value:TRUE);
 set_kb_item(name:"CVE-2007-5960", value:TRUE);
}

set_kb_item(name:"RHSA-2007-1083", value:TRUE);
