#
# (C) Tenable Network Security
#
#
# The text of this plugin is (C) Red Hat Inc.

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(30004);
 script_version ("$Revision: 1.1 $");
 script_cve_id("CVE-2008-0006");

 name["english"] = "RHSA-2008-0064: libXfont";
 
 script_name(english:name["english"]);
 
 desc["english"] = '

  An updated X.Org libXfont package that fixes a security issue is now
  available for Red Hat Enterprise Linux 5.

  This update has been rated as having important security impact by the Red
  Hat Security Response Team.

  The libXfont package contains the X.Org X11 libXfont runtime library.

  A heap based buffer overflow flaw was found in the way the X.Org server
  handled malformed font files. A malicious local user could exploit this
  issue to potentially execute arbitrary code with the privileges of the
  X.Org server. (CVE-2008-0006)

  Users of X.Org libXfont should upgrade to these updated packages, which
  contain a backported patch to resolve this issue.




Solution : http://rhn.redhat.com/errata/RHSA-2008-0064.html
Risk factor : High';

 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the libXfont packages";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2008 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"libXfont-1.2.2-1.0.3.el5_1", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"libXfont-devel-1.2.2-1.0.3.el5_1", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"libXfont-1.2.2-1.0.3.el5_1", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}

if ( rpm_exists(rpm:"libXfont-", release:"RHEL5") )
{
 set_kb_item(name:"CVE-2008-0006", value:TRUE);
}
if ( rpm_exists(rpm:"libXfont-", release:"RHEL5") )
{
 set_kb_item(name:"CVE-2008-0006", value:TRUE);
}

set_kb_item(name:"RHSA-2008-0064", value:TRUE);
