#
# (C) Tenable Network Security
#
#
# The text of this plugin is (C) Red Hat Inc.

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(30091);
 script_version ("$Revision: 1.1 $");
 script_cve_id("CVE-2007-4770", "CVE-2007-4771");

 name["english"] = "RHSA-2008-0090: icu";
 
 script_name(english:name["english"]);
 
 desc["english"] = '

  Updated icu packages that fix two security issues are now available for Red
  Hat Enterprise Linux 5.

  This update has been rated as having important security impact by the Red
  Hat Security Response Team.

  The International Components for Unicode (ICU) library provides robust and
  full-featured Unicode services.

  Will Drewry reported multiple flaws in the way libicu processed certain
  malformed regular expressions. If an application linked against ICU, such
  as OpenOffice.org, processed a carefully crafted regular expression, it may
  be possible to execute arbitrary code as the user running the application.
  (CVE-2007-4770, CVE-2007-4771)

  All users of icu should upgrade to these updated packages, which contain
  backported patches to resolve these issues.




Solution : http://rhn.redhat.com/errata/RHSA-2008-0090.html
Risk factor : High';

 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the icu packages";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2008 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"icu-3.6-5.11.1", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"libicu-3.6-5.11.1", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"libicu-devel-3.6-5.11.1", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"libicu-doc-3.6-5.11.1", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"icu-3.6-5.11.1", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"libicu-3.6-5.11.1", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"libicu-doc-3.6-5.11.1", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}

if ( rpm_exists(rpm:"icu-", release:"RHEL5") )
{
 set_kb_item(name:"CVE-2007-4770", value:TRUE);
 set_kb_item(name:"CVE-2007-4771", value:TRUE);
}
if ( rpm_exists(rpm:"icu-", release:"RHEL5") )
{
 set_kb_item(name:"CVE-2007-4770", value:TRUE);
 set_kb_item(name:"CVE-2007-4771", value:TRUE);
}

set_kb_item(name:"RHSA-2008-0090", value:TRUE);
