#
# (C) Tenable Network Security
#
#
# The text of this plugin is (C) Red Hat Inc.

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(31160);
 script_version ("$Revision: 1.1 $");
 script_cve_id("CVE-2007-4772", "CVE-2007-5378", "CVE-2008-0553");

 name["english"] = "RHSA-2008-0134: expect";
 
 script_name(english:name["english"]);
 
 desc["english"] = '

  Updated tcltk packages that fix a security issue are now available for Red
  Hat Enterprise Linux 2.1, and 3.

  This update has been rated as having moderate security impact by the Red
  Hat Security Response Team.

  Tcl is a scripting language designed for embedding into other applications
  and for use with Tk, a widget set.

  An input validation flaw was discovered in Tk\'s GIF image handling. A
  code-size value read from a GIF image was not properly validated before
  being used, leading to a buffer overflow. A specially crafted GIF file
  could use this to cause a crash or, potentially, execute code with the
  privileges of the application using the Tk graphical toolkit.
  (CVE-2008-0553)

  A buffer overflow flaw was discovered in Tk\'s animated GIF image handling.
  An animated GIF containing an initial image smaller than subsequent images
  could cause a crash or, potentially, execute code with the privileges of
  the application using the Tk library. (CVE-2007-5378)

  A flaw in the Tcl regular expression handling engine was discovered by Will
  Drewry. This flaw, first discovered in the Tcl regular expression engine
  used in the PostgreSQL database server, resulted in an infinite loop when
  processing certain regular expressions. (CVE-2007-4772)

  All users are advised to upgrade to these updated packages which contain
  backported patches which resolve these issues.




Solution : http://rhn.redhat.com/errata/RHSA-2008-0134.html
Risk factor : High';

 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the expect packages";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2008 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"expect-5.38.0-75", release:"RHEL2.1") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"itcl-3.2-75", release:"RHEL2.1") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"tcl-8.3.3-75", release:"RHEL2.1") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"tcllib-1.0-75", release:"RHEL2.1") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"tclx-8.3-75", release:"RHEL2.1") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"tix-8.2.0b1-75", release:"RHEL2.1") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"tk-8.3.3-75", release:"RHEL2.1") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"expect-5.38.0-92.8", release:"RHEL3") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"expect-devel-5.38.0-92.8", release:"RHEL3") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"itcl-3.2-92.8", release:"RHEL3") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"tcl-8.3.5-92.8", release:"RHEL3") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"tcl-devel-8.3.5-92.8", release:"RHEL3") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"tclx-8.3-92.8", release:"RHEL3") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"tix-8.1.4-92.8", release:"RHEL3") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"tk-8.3.5-92.8", release:"RHEL3") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"tk-devel-8.3.5-92.8", release:"RHEL3") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"expect-5.38.0-75", release:"RHEL2.1") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"itcl-3.2-75", release:"RHEL2.1") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"tcl-8.3.3-75", release:"RHEL2.1") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"tcllib-1.0-75", release:"RHEL2.1") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"tclx-8.3-75", release:"RHEL2.1") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"tix-8.2.0b1-75", release:"RHEL2.1") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"tk-8.3.3-75", release:"RHEL2.1") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"expect-5.38.0-75", release:"RHEL2.1") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"itcl-3.2-75", release:"RHEL2.1") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"tcl-8.3.3-75", release:"RHEL2.1") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"tcllib-1.0-75", release:"RHEL2.1") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"tclx-8.3-75", release:"RHEL2.1") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"tix-8.2.0b1-75", release:"RHEL2.1") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"tk-8.3.3-75", release:"RHEL2.1") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}

if ( rpm_exists(rpm:"expect-", release:"RHEL2.1") )
{
 set_kb_item(name:"CVE-2007-4772", value:TRUE);
 set_kb_item(name:"CVE-2007-5378", value:TRUE);
 set_kb_item(name:"CVE-2008-0553", value:TRUE);
}
if ( rpm_exists(rpm:"expect-", release:"RHEL3") )
{
 set_kb_item(name:"CVE-2007-4772", value:TRUE);
 set_kb_item(name:"CVE-2007-5378", value:TRUE);
 set_kb_item(name:"CVE-2008-0553", value:TRUE);
}
if ( rpm_exists(rpm:"expect-", release:"RHEL2.1") )
{
 set_kb_item(name:"CVE-2007-4772", value:TRUE);
 set_kb_item(name:"CVE-2007-5378", value:TRUE);
 set_kb_item(name:"CVE-2008-0553", value:TRUE);
}
if ( rpm_exists(rpm:"expect-", release:"RHEL2.1") )
{
 set_kb_item(name:"CVE-2007-4772", value:TRUE);
 set_kb_item(name:"CVE-2007-5378", value:TRUE);
 set_kb_item(name:"CVE-2008-0553", value:TRUE);
}

set_kb_item(name:"RHSA-2008-0134", value:TRUE);
