#
# (C) Tenable Network Security
#
#
# The text of this plugin is (C) Red Hat Inc.

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(31306);
 script_version ("$Revision: 1.1 $");
 script_cve_id("CVE-2006-4484", "CVE-2007-0455", "CVE-2007-2756", "CVE-2007-3472", "CVE-2007-3473", "CVE-2007-3475", "CVE-2007-3476");

 name["english"] = "RHSA-2008-0146: gd";
 
 script_name(english:name["english"]);
 
 desc["english"] = '

  Updated gd packages that fix multiple security issues are now available for
  Red Hat Enterprise Linux 4 and 5.

  This update has been rated as having moderate security impact by the Red
  Hat Security Response Team.

  The gd package contains a graphics library used for the dynamic creation of
  images such as PNG and JPEG.

  Multiple issues were discovered in the gd GIF image-handling code. A
  carefully-crafted GIF file could cause a crash or possibly execute code
  with the privileges of the application using the gd library.
  (CVE-2006-4484, CVE-2007-3475, CVE-2007-3476)

  An integer overflow was discovered in the gdImageCreateTrueColor()
  function, leading to incorrect memory allocations. A carefully crafted
  image could cause a crash or possibly execute code with the privileges of
  the application using the gd library. (CVE-2007-3472)

  A buffer over-read flaw was discovered. This could cause a crash in an
  application using the gd library to render certain strings using a
  JIS-encoded font. (CVE-2007-0455)

  A flaw was discovered in the gd PNG image handling code. A truncated PNG
  image could cause an infinite loop in an application using the gd library.
  (CVE-2007-2756)

  A flaw was discovered in the gd X BitMap (XBM) image-handling code. A
  malformed or truncated XBM image could cause a crash in an application
  using the gd library. (CVE-2007-3473)

  Users of gd should upgrade to these updated packages, which contain
  backported patches which resolve these issues.




Solution : http://rhn.redhat.com/errata/RHSA-2008-0146.html
Risk factor : High';

 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the gd packages";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2008 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"gd-2.0.33-9.4.el5_1.1", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"gd-devel-2.0.33-9.4.el5_1.1", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"gd-progs-2.0.33-9.4.el5_1.1", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"gd-2.0.28-5.4E.el4_6.1", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"gd-devel-2.0.28-5.4E.el4_6.1", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"gd-progs-2.0.28-5.4E.el4_6.1", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"gd-2.0.33-9.4.el5_1.1", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"gd-progs-2.0.33-9.4.el5_1.1", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"gd-2.0.28-5.4E.el4_6.1", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"gd-devel-2.0.28-5.4E.el4_6.1", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"gd-progs-2.0.28-5.4E.el4_6.1", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"gd-2.0.28-5.4E.el4_6.1", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"gd-devel-2.0.28-5.4E.el4_6.1", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"gd-progs-2.0.28-5.4E.el4_6.1", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}

if ( rpm_exists(rpm:"gd-", release:"RHEL5") )
{
 set_kb_item(name:"CVE-2006-4484", value:TRUE);
 set_kb_item(name:"CVE-2007-0455", value:TRUE);
 set_kb_item(name:"CVE-2007-2756", value:TRUE);
 set_kb_item(name:"CVE-2007-3472", value:TRUE);
 set_kb_item(name:"CVE-2007-3473", value:TRUE);
 set_kb_item(name:"CVE-2007-3475", value:TRUE);
 set_kb_item(name:"CVE-2007-3476", value:TRUE);
}
if ( rpm_exists(rpm:"gd-", release:"RHEL4") )
{
 set_kb_item(name:"CVE-2006-4484", value:TRUE);
 set_kb_item(name:"CVE-2007-0455", value:TRUE);
 set_kb_item(name:"CVE-2007-2756", value:TRUE);
 set_kb_item(name:"CVE-2007-3472", value:TRUE);
 set_kb_item(name:"CVE-2007-3473", value:TRUE);
 set_kb_item(name:"CVE-2007-3475", value:TRUE);
 set_kb_item(name:"CVE-2007-3476", value:TRUE);
}
if ( rpm_exists(rpm:"gd-", release:"RHEL5") )
{
 set_kb_item(name:"CVE-2006-4484", value:TRUE);
 set_kb_item(name:"CVE-2007-0455", value:TRUE);
 set_kb_item(name:"CVE-2007-2756", value:TRUE);
 set_kb_item(name:"CVE-2007-3472", value:TRUE);
 set_kb_item(name:"CVE-2007-3473", value:TRUE);
 set_kb_item(name:"CVE-2007-3475", value:TRUE);
 set_kb_item(name:"CVE-2007-3476", value:TRUE);
}
if ( rpm_exists(rpm:"gd-", release:"RHEL4") )
{
 set_kb_item(name:"CVE-2006-4484", value:TRUE);
 set_kb_item(name:"CVE-2007-0455", value:TRUE);
 set_kb_item(name:"CVE-2007-2756", value:TRUE);
 set_kb_item(name:"CVE-2007-3472", value:TRUE);
 set_kb_item(name:"CVE-2007-3473", value:TRUE);
 set_kb_item(name:"CVE-2007-3475", value:TRUE);
 set_kb_item(name:"CVE-2007-3476", value:TRUE);
}
if ( rpm_exists(rpm:"gd-", release:"RHEL4") )
{
 set_kb_item(name:"CVE-2006-4484", value:TRUE);
 set_kb_item(name:"CVE-2007-0455", value:TRUE);
 set_kb_item(name:"CVE-2007-2756", value:TRUE);
 set_kb_item(name:"CVE-2007-3472", value:TRUE);
 set_kb_item(name:"CVE-2007-3473", value:TRUE);
 set_kb_item(name:"CVE-2007-3475", value:TRUE);
 set_kb_item(name:"CVE-2007-3476", value:TRUE);
}

set_kb_item(name:"RHSA-2008-0146", value:TRUE);
