#
# (C) Tenable Network Security, Inc.
#


  desc = "
Synopsis :

The remote host contains an application that is prone to a denial of
service attack. 

Description :

The remote host appears to be running Rendezvous, a commercial
messaging software product used for building distributed applications

According to its banner, Rendezvous' rvd daemon fails to properly
validate input in incoming packets before using it to allocate memory. 
By sending a specially-crafted packet with a length field of 0, an
unauthenticated remote attacker may be able to leak memory and
eventually exhaust memory on the affected system. 

See also :

http://www.irmplc.com/index.php/160-Advisory-025

Solution :

Upgrade to TIBCO Rendezvous version 8.0 or later as that reportedly
addresses the issue. 

Risk factor :

High / CVSS Base Score : 7.8
(CVSS2#AV:N/AC:L/Au:N/C:N/I:N/A:C)";


if (description)
{
  script_id(28376);
  script_version("$Revision: 1.3 $");

  script_cve_id("CVE-2007-4158");
  script_bugtraq_id(25132);
  script_xref(name:"OSVDB", value:"37680");

  script_name(english:"Rendezvous < 8.0.0 Denial of Service Vulnerability");
  script_summary(english:"Checks version of Rendezvous browser admin interface");

  script_description(english:desc);

  script_category(ACT_GATHER_INFO);
  script_family(english:"Denial of Service");

  script_copyright(english:"This script is Copyright (C) 2007-2008 Tenable Network Security, Inc.");

  script_dependencies("http_version.nasl");
  script_require_ports("Services/www", 7580, 7585);

  exit(0);
}


include("http_func.inc");


port = get_kb_item("Services/www");
if (!port) port = 7580;
if (!get_port_state(port)) exit(0);


# Check the version in the banner.
banner = get_http_banner(port:port);
if (!banner) exit(0);

banner = strstr(banner, "Server:");
banner = banner - strstr(banner, '\r\n');
if ("Rendezvous HTTP Server " >< banner)
{
  version = strstr(banner, "Rendezvous HTTP Server ") - "Rendezvous HTTP Server ";
  if (version =~ "^[0-7]\.")
  {
    report = string(
      desc,
      "\n\n",
      "Plugin output :\n",
      "\n",
      "The Rendezvous browser administration interface on the remote host\n",
      "returned the following banner :\n",
      "\n",
      "  ", banner, "\n"
    );
    security_hole(port:port, data:report);
  }
}
