#
# (C) Tenable Network Security
#


if(description)
{
 script_id(20759);
 script_bugtraq_id(205);
 script_version ("$Revision: 1.3 $");
 script_cve_id("CVE-1999-0632", "CVE-1999-0189");
 name["english"] = "RPC portmapper on a port different than 111";
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

An ONC RPC portmapper is running on the remote host.

Description :

The RPC portmapper is running on this port.

The portmapper allows to get the port number of each RPC service
running on the remote host either by sending multiple lookup
requests or by sending a DUMP request.

This service should only run on port 111. However on some operating
systems it also listens on different UDP ports. This might allow an
attacker to circumvent firewall rules.

Risk factor : 

Medium / CVSS Base Score : 4.0
(CVSS2#AV:N/AC:L/Au:S/C:P/I:N/A:N)";

 script_description(english:desc["english"]);
 
 summary["english"] = "Gets the port of the remote rpc portmapper";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc");
 family["english"] = "RPC"; 
 script_family(english:family["english"]);
 script_dependencie("rpc_portmap.nasl");
 script_require_keys("rpc/portmap/different_port");
 exit(0);
}

ports = get_kb_list("rpc/portmap/different_port");
if ( isnull(ports) ) exit(0);
foreach p ( make_list(ports) ) if ( p != 111 ) security_warning(p);
