#
# (C) Tenable Network Security
#

 desc = "
Synopsis :

It is possible to leak information about the remote server.

Description :

The remote host is running the rstatd RPC service. This service provides
information such as :

 - the CPU usage
 - the system uptime
 - the network usage

Solution : 

Disable this service if not needed.

Risk factor : 

None";


if(description)
{
 script_id(10227);
 script_version ("$Revision: 1.21 $");
 script_cve_id("CVE-1999-0624");

 name["english"] = "rstatd service";
 script_name(english:name["english"]);
 script_description(english:desc);
 
 summary["english"] = "Checks the presence of a RPC service";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "RPC"; 
 script_family(english:family["english"]);
 
 script_dependencie("rpc_portmap.nasl");
 script_require_keys("rpc/portmap");
 exit(0);
}


#
# The script code starts here
#

include ("sunrpc_func.inc");

function uptime (sec)
{
 return string (sec/3600, "h ", (sec/60)%60, "m ", sec%60, "s");
}


RPC_PROG = 100001;
tcp = 0;
port = get_rpc_port2(program:RPC_PROG, protocol:IPPROTO_UDP);
if (!port)
{
 port = get_rpc_port2(program:RPC_PROG, protocol:IPPROTO_TCP);
 tcp = 1;
}


if(port)
{
 if(tcp)
 {
  soc = open_sock_tcp (port);
  if (!soc) exit(0);
  udp = FALSE;
 }
 else
 {
  soc = open_sock_udp (port);
  if (!soc) exit(0);
  udp = TRUE;
 }

 data = NULL;

 packet = rpc_packet (prog:RPC_PROG, vers:3, proc:0x01, data:data, udp:udp);

 data = rpc_sendrecv (socket:soc, packet:packet, udp:udp);
 if (isnull(data) || (strlen(data) != 104))
   exit(0);

 report = string (
	"uptime: ", uptime(sec:getdword(blob:data, pos:92) - getdword(blob:data, pos:84)),
	"\n",
	"cpu usage: ",
	"user ", getdword(blob:data,pos:0), ", ",
	"nice ", getdword(blob:data,pos:4), ", ",
	"system ", getdword(blob:data,pos:8), ", ",
	"idle ", getdword(blob:data,pos:12),
	"\n",
	"disk transfer: ",
	"d1 ", getdword(blob:data,pos:16), ", ",
	"d1 ", getdword(blob:data,pos:20), ", ",
	"d1 ", getdword(blob:data,pos:24), ", ",
	"d1 ", getdword(blob:data,pos:28),
	"\n",
	"memory: ",
	"pagein ", getdword(blob:data,pos:32), ", ",
	"pageout ", getdword(blob:data,pos:36), ", ",
	"swapin ", getdword(blob:data,pos:40), ", ",
	"swapout ", getdword(blob:data,pos:44)
	);

 report = string (desc, "\n\nPlugin output :\n\n", report);

 if (tcp)
   security_note(port, data:report);
 else
   security_note(port, protocol:"udp", data:report);
}
