#
# This script was written by Tenable Network Security
#

 desc["english"] = "
Synopsis :

It is possible to enumerate logged in users.

Description :

The rusersd RPC service is running.  It provides an attacker interesting
information such as how often the system is being used, the names of the
users, and more.

Solution :

Disable this service if not needed.

Risk factor:

Medium / CVSS Base Score : 5.0
(CVSS2#AV:N/AC:L/Au:N/C:P/I:N/A:N)";

if(description)
{
 script_id(11058);
 script_version ("$Revision: 1.8 $");
 script_cve_id("CVE-1999-0626");
 
 name["english"] = "rusersd output";

 script_name(english:name["english"]);
 
 script_description(english:desc["english"]);
 
 summary["english"] = "Checks the presence of a RPC service";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc");

 family["english"] = "RPC"; 
 script_family(english:family["english"]);
 script_dependencie("rpc_portmap.nasl");
 script_require_keys("rpc/portmap");
 exit(0);
}

#
# The script code starts here
#

include("sunrpc_func.inc");


RPC_PROG = 100002;
RUSERSPROC_NAME = 0x02;

port = get_rpc_port2(program:RPC_PROG, protocol:IPPROTO_UDP);

if(port)
{
 soc = open_sock_udp (port);
 if (!soc) exit(0);
 udp = TRUE;

 data = NULL;

 packet = rpc_packet (prog:RPC_PROG, vers:2, proc:RUSERSPROC_NAME, data:data, udp:udp);

 data = rpc_sendrecv (socket:soc, packet:packet, udp:udp);
 if (isnull(data) || (strlen(data) < 4))
   exit(0);

 register_stream(s:data);

 users = xdr_getdword();
 report = NULL;

 for (i=0; i<users; i++)
 {
  term = xdr_getstring();
  user = xdr_getstring();
  disp = xdr_getstring();

  xdr_getdword();
  xdr_getdword();

  report += string (user, " (", term, ") from ", disp, "\n");
 }

 if (report)
 {
  report = string (
		desc["english"],
		"\n\nPlugin output :\n\n",
		"Using rusers, we could determine that the following users are logged in :\n\n",
		report
		);
  security_warning(port, data:report);
 }
 else
  security_warning(port, data:report);
}
