#
# This script was written by Michel Arboi <arboi@alussinan.org>
#
# GPL
#

if(description)
{
  script_id(11929);
  script_version ("$Revision: 1.16 $");
 
  script_name(english:"SAP DB / MaxDB Detection");
 
  desc["english"] = "
Synopsis :

A SAP DB or MaxDB database server is listening on the remote port.

Description :

SAP DB or MaxDB, an ERP software, is running on the remote
port.

See also :

https://www.sdn.sap.com/irj/sdn/maxdb (requires credentials)
http://www.mysql.com/products/maxdb/

Solution : 

If this service is not needed, disable it or filter incoming traffic
to this port.

Risk factor : 

None";
  script_description(english:desc["english"]);
 
  summary["english"] = "Detect SAP DB / MaxDB server";
  script_summary(english:summary["english"]);
 
  script_category(ACT_GATHER_INFO);
 
  script_copyright(english:"This script is Copyright (C) 2003 Michel Arboi");
  script_family(english:"Service detection");
  script_dependencies("find_service2.nasl");
  script_require_ports("Services/unknown", 7210);
  exit(0);
}

include("byte_func.inc");
include("global_settings.inc");
include("misc_func.inc");


if (thorough_tests && ! get_kb_item("global_settings/disable_service_discovery")  )
{
  port = get_unknown_svc(7210);
  if (!port) exit(0);
  if (silent_service(port)) exit(0); 
}
else port = 7210;
if (known_service(port:port)) exit(0);
if (!get_tcp_port_state(port)) exit(0);


s = open_sock_tcp(port);
if ( ! s ) exit(0);

set_byte_order(BYTE_ORDER_LITTLE_ENDIAN);
db = raw_string(
  0x00, 0xc5, 0x09, 0x00, 0xc8, 0xf6, 0x08, 0x00, 
  0x00, 0xe3, 0x0a, 0x00, 0xd4, 0x00, 0x00, 0x00
);

r = 
  mkdword(0) +                         # size (to be filled in later)
  mkdword(0x5b03) +                    # ?, but constant
  mkdword(1) +                         # ?, but constant
  mkdword(0xffffffff) +
  mkdword(0x040000) +
  mkdword(0) +                         # size (to be filled in later)
  mkdword(0x3f0200) +
  mkdword(0x0904) +
  mkdword(0x4000) +
  mkdword(0x3fd0) +
  mkdword(0x4000) +
  mkdword(0x70) +
  db +
  mkbyte(7) + "I1016" + mkword(0x400) +
  mkdword(0x032a1c50) +
  mkword(0x0152) +
  mkbyte(0x09) +
  "pdbmsrv" +
  mkbyte(0x00);
r = insstr(r, mkdword(strlen(r)), 0, 3);
r = insstr(r, mkdword(strlen(r)), 20, 23);
send(socket:s, data:r);
length = recv(socket: s, length:4, min:4);
if (strlen(length) != 4)
  exit (0);

length = getdword(blob:length, pos:0) - 4;
if (length < 7 || length > 65535)
  exit (0);

r2 = recv(socket: s, length:length, min:length);
if (strlen(r2) != length)
  exit (0);

if (getdword(blob:r2, pos:0) == 0x5c03)
{
  info = "";

  # Send a "version" command.
  r = 
    mkdword(0) +                       # size (to be filled in later)
    mkdword(0x3f03) +                  # ?, but constant
    mkdword(1) +                       # ?, but constant
    mkdword(0x06cc) +
    mkdword(0x040000) +
    mkdword(0) +                         # size (to be filled in later)
    "dbm_version";
  r = insstr(r, mkdword(strlen(r)), 0, 3);
  r = insstr(r, mkdword(strlen(r)), 20, 23);
  send(socket:s, data:r);
  length = recv(socket: s, length:4, min:4);
  if (strlen(length) == 4)
  {
    length = getdword(blob:length, pos:0) - 4;
    if (length >= 7)
    {
      r2 = recv(socket: s, length:length, min:length);
      if (strlen(r2) == length && "VERSION " >< r2)
      {
        info = strstr(r2, "VERSION ");
        foreach line (split(info, sep:'\n', keep:FALSE))
        {
          items = eregmatch(pattern:"^([^ =]+) *= *(.*)$", string:line);
          if (items)
          {
            key = items[1];
            val = items[2];
            set_kb_item(name:"SAPDB/"+port+"/"+key, value:val);
          }
        }
      }
    }
  }

  if (info && report_verbosity > 0)
  {
    report = string(
      "\n",
      "Sending a 'version' command to the remote host returned :\n",
      "\n",
      info
    );
    security_note(port:port, extra:report);
  }
  else security_note(port);

  register_service(port: port, proto: "sap_db_vserver");
}
close(s);
