#
# (C) Tenable Network Security
#


if (description)
{
  script_id(23928);
  script_version("$Revision: 1.4 $");

  script_cve_id(
    "CVE-2006-6497",
    "CVE-2006-6498",
    "CVE-2006-6499",
    "CVE-2006-6500",
    "CVE-2006-6501",
    "CVE-2006-6502",
    "CVE-2006-6503",
    "CVE-2006-6504",
    "CVE-2006-6505"
  );
  script_bugtraq_id(21668);

  script_name(english:"SeaMonkey < 1.0.7");
  script_summary(english:"Checks version of SeaMonkey");

  desc = "
Synopsis :

A web browser on the remote host is prone to multiple flaws. 

Description :

The installed version of SeaMonkey contains various security issues,
some of which may lead to execution of arbitrary code on the affected
host subject to the user's privileges. 

See also :

http://www.mozilla.org/security/announce/2006/mfsa2006-68.html
http://www.mozilla.org/security/announce/2006/mfsa2006-69.html
http://www.mozilla.org/security/announce/2006/mfsa2006-70.html
http://www.mozilla.org/security/announce/2006/mfsa2006-71.html
http://www.mozilla.org/security/announce/2006/mfsa2006-72.html
http://www.mozilla.org/security/announce/2006/mfsa2006-73.html
http://www.mozilla.org/security/announce/2006/mfsa2006-74.html

Solution : 

Upgrade to SeaMonkey 1.0.7 or later. 

Risk factor : 

High / CVSS Base Score : 9.3
(CVSS2#AV:N/AC:M/Au:N/C:C/I:C/A:C)";
  script_description(english:desc);
 
  script_category(ACT_GATHER_INFO);
  script_family(english:"Windows");
 
  script_copyright(english:"This script is Copyright (C) 2006-2007 Tenable Network Security");
 
  script_dependencies("mozilla_org_installed.nasl");
  script_require_keys("SeaMonkey/Version");


  exit(0);
}


include("misc_func.inc");


ver = read_version_in_kb("SeaMonkey/Version");
if (isnull(ver)) exit(0);

if (
  ver[0] < 1 ||
  (ver[0] == 1 && ver[1] == 0 && ver[2] < 7)
) security_hole(get_kb_item("SMB/transport"));
