#
# (C) Tenable Network Security
#


if (description)
{
  script_id(24735);
  script_version("$Revision: 1.14 $");

  script_cve_id(
    "CVE-2006-6077",
    "CVE-2007-0008",
    "CVE-2007-0009",
    "CVE-2007-0775",
    "CVE-2007-0776",
    "CVE-2007-0777",
    "CVE-2007-0778",
    "CVE-2007-0779",
    "CVE-2007-0780",
    "CVE-2007-0800",
    "CVE-2007-0801",
    "CVE-2007-0802",
    "CVE-2007-0981",
    "CVE-2007-0994",
    "CVE-2007-0995",
    "CVE-2007-0996",
    "CVE-2007-1092",
    "CVE-2007-1282"
  );
  script_bugtraq_id(21240, 22396, 22566, 22679, 22694, 22826, 22845);
  script_xref(name:"OSVDB", value:"32104");
  script_xref(name:"OSVDB", value:"32105");
  script_xref(name:"OSVDB", value:"32106");
  script_xref(name:"OSVDB", value:"32107");
  script_xref(name:"OSVDB", value:"32108");
  script_xref(name:"OSVDB", value:"32110");
  script_xref(name:"OSVDB", value:"32111");
  script_xref(name:"OSVDB", value:"32113");
  script_xref(name:"OSVDB", value:"32114");
  script_xref(name:"OSVDB", value:"32115");

  script_name(english:"SeaMonkey < 1.0.8");
  script_summary(english:"Checks version of SeaMonkey");

  desc = "
Synopsis :

A web browser on the remote host is prone to multiple flaws. 

Description :

The installed version of SeaMonkey contains various security issues,
some of which may lead to execution of arbitrary code on the affected
host subject to the user's privileges. 

See also :

http://www.mozilla.org/security/announce/2007/mfsa2007-01.html
http://www.mozilla.org/security/announce/2007/mfsa2007-02.html
http://www.mozilla.org/security/announce/2007/mfsa2007-03.html
http://www.mozilla.org/security/announce/2007/mfsa2007-04.html
http://www.mozilla.org/security/announce/2007/mfsa2007-05.html
http://www.mozilla.org/security/announce/2007/mfsa2007-06.html
http://www.mozilla.org/security/announce/2007/mfsa2007-07.html
http://www.mozilla.org/security/announce/2007/mfsa2007-08.html
http://www.mozilla.org/security/announce/2007/mfsa2007-09.html
http://www.mozilla.org/security/announce/2007/mfsa2007-10.html

Solution : 

Upgrade to SeaMonkey 1.0.8 or later. 

Risk factor : 

High / CVSS Base Score : 9.3
(CVSS2#AV:N/AC:M/Au:N/C:C/I:C/A:C)";
  script_description(english:desc);
 
  script_category(ACT_GATHER_INFO);
  script_family(english:"Windows");
 
  script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 
  script_dependencies("mozilla_org_installed.nasl");
  script_require_keys("SeaMonkey/Version");

  exit(0);
}


include("misc_func.inc");


ver = read_version_in_kb("SeaMonkey/Version");
if (isnull(ver)) exit(0);

if (
  ver[0] < 1 ||
  (ver[0] == 1 && ver[1] == 0 && ver[2] < 8)
) security_hole(get_kb_item("SMB/transport"));
