#
# (C) Tenable Network Security, Inc.
#


  desc = "
Synopsis :

The remote web server contains a PHP application that is affected by
an authentication bypass vulnerability. 

Description :

The remote host is running Shop-Script, a shopping cart software
application written in PHP. 

The version of Shop-Script installed on the remote host fails to halt
execution of the script 'admin.php' if an attacker is not
authenticated, which allows him to effectively bypass the
authentication check and gain control of the application. 

Note that the application is also likely affected by another
vulnerability that allows for arbitrary code execution by means of
specially-crafted changes to the application's Appearance
configuration settings, although Nessus has not checked for this. 

By leveraging these two issues, a unauthenticated remote attacker is
probably able to execute arbitrary code on the affected host subject
to the privileges of the web server user id. 

See also :

http://www.milw0rm.com/exploits/4419

Solution :

Unknown at this time.

Risk factor : 

High / CVSS Base Score : 7.5
(CVSS2#AV:N/AC:L/Au:N/C:P/I:P/A:P)";


if (description)
{
  script_id(26065);
  script_version("$Revision: 1.4 $");

  script_cve_id("CVE-2007-4932");
  script_bugtraq_id(25695);
  script_xref(name:"OSVDB", value:"40149");

  script_name(english:"Shop-Script Admin Bypass Vulnerability");
  script_summary(english:"Tries to retrieve configuration settings");

  script_description(english:desc);

  script_category(ACT_ATTACK);
  script_family(english:"CGI abuses");

  script_copyright(english:"This script is Copyright (C) 2007-2008 Tenable Network Security, Inc.");

  script_dependencies("http_version.nasl");
  script_exclude_keys("Settings/disable_cgi_scanning");
  script_require_ports("Services/www", 80);

  exit(0);
}


include("global_settings.inc");
include("http_func.inc");
include("http_keepalive.inc");


port = get_http_port(default:80);
if (!get_port_state(port)) exit(0);
if (!can_host_php(port:port)) exit(0);


# Loop through directories.
if (thorough_tests) dirs = make_list("/shopscript", "/shop", "/store", cgi_dirs());
else dirs = make_list(cgi_dirs());

foreach dir (dirs)
{
  # Try to exploit the issue to retrieve the general configuration settings.
  req = http_get(
    item:string(dir, "/admin.php?dpt=conf&sub=general"), 
    port:port
  );
  res = http_keepalive_send_recv(port:port, data:req, bodyonly:FALSE);
  if (res == NULL) exit(0);

  # There's a problem if...
  if (
    # we gain access to the main form and...
    '<form action="admin.php' >< res && '<input type=hidden name=save_general' >< res &&
    # there's a redirection to the access_admin.php script
    egrep(pattern:"^Location: +access_admin\.php", string:res)
  )
  {
    security_hole(port);
    exit(0);
  }
}
