#
#  (C) Tenable Network Security
#


 desc = "
Synopsis :

The remote Windows host has an application that is affected by
multiple access bypass vulnerabilities. 

Description :

According to its version number, the installation of SiteKiosk on the
remote host contains an unspecified ActiveX control that is marked as
'safe for scripting' yet exposes two dangerous methods that reading
and downloading of any file from the kiosk.  In addition, it fails to
completely sanitize input in its 'skinning' feature before using it to
generate dynamic HTML output.  By leveraging either issue, a local
user may be able to view the contents of files on the affected host. 

Note that SiteKiosk by default runs with LOCAL SYSTEM privileges. 

See also :

http://archives.neohapsis.com/archives/fulldisclosure/2006-12/0225.html
http://www.sitekiosk.com/th_support/versions/index.php3?id=39

Solution :

Upgrade to SiteKiosk version 6.5.150 or later. 

Risk factor :

Medium / CVSS Base Score : 4.1
(CVSS2#AV:L/AC:M/Au:S/C:P/I:P/A:P)";


if (description)
{
  script_id(23969);
  script_version("$Revision: 1.4 $");

  script_cve_id("CVE-2006-6509", "CVE-2006-6510");
  script_bugtraq_id(21567);

  script_name(english:"SiteKiosk < 6.5.150 Multiple Vulnerabilities");
  script_summary(english:"Checks version of SiteKiosk"); 
 
  script_description(english:desc);
 
  script_category(ACT_GATHER_INFO);
  script_family(english:"Windows");

  script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");

  script_dependencies("smb_hotfixes.nasl");
  script_require_keys("SMB/Registry/Enumerated");
  script_require_ports(139, 445);

  exit(0);
}


include("smb_func.inc");


# Connect to the appropriate share.
if (!get_kb_item("SMB/Registry/Enumerated")) exit(0);
name    =  kb_smb_name();
port    =  kb_smb_transport();
if (!get_port_state(port)) exit(0);
login   =  kb_smb_login();
pass    =  kb_smb_password();
domain  =  kb_smb_domain();

soc = open_sock_tcp(port);
if (!soc) exit(0);

session_init(socket:soc, hostname:name);
rc = NetUseAdd(login:login, password:pass, domain:domain, share:"IPC$");
if (rc != 1)
{
  NetUseDel();
  exit(0);
}


# Connect to remote registry.
hklm = RegConnectRegistry(hkey:HKEY_LOCAL_MACHINE);
if (isnull(hklm))
{
  NetUseDel();
  exit(0);
}


# Check whether it's installed.
path = NULL;
key = "SOFTWARE\PROVISIO\SiteKiosk";
key_h = RegOpenKey(handle:hklm, key:key, mode:MAXIMUM_ALLOWED);
if (!isnull(key_h))
{
  value = RegQueryValue(handle:key_h, item:"InstallDir");
  if (!isnull(value)) path = value[1];

  RegCloseKey(handle:key_h);
}
RegCloseKey(handle:hklm);
if (isnull(path)) {
  NetUseDel();
  exit(0);
}


# Determine the version from the program itself.
share = ereg_replace(pattern:"^([A-Za-z]):.*", replace:"\1$", string:path);
exe =  ereg_replace(pattern:"^[A-Za-z]:(.*)", replace:"\1\SiteKiosk.exe", string:path);
NetUseDel(close:FALSE);

rc = NetUseAdd(login:login, password:pass, domain:domain, share:share);
if (rc != 1)
{
  NetUseDel();
  exit(0);
}

fh = CreateFile(
  file:exe,
  desired_access:GENERIC_READ,
  file_attributes:FILE_ATTRIBUTE_NORMAL,
  share_mode:FILE_SHARE_READ,
  create_disposition:OPEN_EXISTING
);
if (!isnull(fh))
{
  ver = GetFileVersion(handle:fh);
  CloseFile(handle:fh);
}

# Check the version number.
if (!isnull(ver))
{
  fix = split("6.5.150.0", sep:'.', keep:FALSE);
  for (i=0; i<4; i++)
    fix[i] = int(fix[i]);

  for (i=0; i<max_index(ver); i++)
    if ((ver[i] < fix[i]))
    {
      version = string(ver[0], ".", ver[1], ".", ver[2], ".", ver[3]);
      report = desc + string(
        "\n\n",
        "Plugin output :\n",
        "\n",
        "Version ", version, " of SiteKiosk is installed under : \n",
        "\n",
        "  ", path, "\n"
      );
      security_warning(port:port, data:report);
      break;
    }
    else if (ver[i] > fix[i])
      break;
}


# Clean up.
NetUseDel();


