#
# (C) Tenable Network Security
#

if ( NASL_LEVEL < 3000 ) exit(0);

if (description)
{
  script_id(30206);
  script_version("$Revision: 1.2 $");

  script_cve_id("CVE-2008-0454", "CVE-2008-0582", "CVE-2008-0583");
  script_bugtraq_id(27338);

  script_name(english:"Skype Web Content Zone Remote Code Execution Vulnerability");
  script_summary(english:"Checks version of Skype");
 
  desc = "
Synopsis :

The remote Skype client is affected by a remote code execution issue
through the web handler.

Description :

The version of Skype installed on the remote host reportedly may allow
a remote attacker to execute arbitrary code by enticing the user to
retrieve specially crafted we content through the skype interface.

See also :

http://www.skype.com/security/skype-sb-2008-001-update2.html
http://www.skype.com/security/skype-sb-2008-002.html
http://www.skype.com/security/skype-sb-2008-001-update1.html

Solution :

Upgrade to Skype release 3.6.0.248 or later. 

Risk factor : 

Risk factor :

High / CVSS Base Score : 7.6 
(CVSS2#AV:N/AC:H/Au:N/C:C/I:C/A:C)";

  script_description(english:desc);

  script_category(ACT_GATHER_INFO);
  script_family(english:"Windows");

  script_copyright(english:"This script is Copyright (C) 2008 Tenable Network Security");

  script_dependencies("skype_version.nbin", "smb_nativelanman.nasl");
  script_require_keys("Services/skype");
  script_require_ports(139, 445);

  exit(0);
}


# The flaw only affects Windows hosts.
os = get_kb_item("Host/OS/smb");
if (!os || "Windows" >!< os) exit(0);


port = get_kb_item("Services/skype");
if (!port) exit(0);
if (!get_port_state(port)) exit(0);


# nb: "ts = 802011429" => "version = 3.6.0.248"
ts = get_kb_item("Skype/" + port + "/stackTimeStamp");
if (ts && ts < 802011429) security_note(port);
