#
# (C) Tenable Network Security
#

desc["english"] = "

Synopsis :

The remote host seems to contain material (movies/audio) infringing 
copyright.

Description :

This plugin displays a list of files which have been found on the 
remote SMB shares.

Some of these files may contain copyrighted materials, such as commercial
movies or music files. 

If any of this file actually contains copyrighted material and if
they are freely swapped around, your organization might be held liable
for copyright infringement by associations such as the RIAA or the MPAA.

Solution :

Delete the files infringing copyright.

Risk factor :

None

";

if(description)
{
 script_id(11777);
 script_version ("$Revision: 1.26 $");

 name["english"] = "SMB share hosting copyrighted material";
 script_name(english:name["english"]);

 desc["english"] = "
This script connects to the remotely accessible SMB shares
and attempts to find potentially copyrighted contents on it
(such as .mp3, .ogg, .mpg or .avi files).";

 script_description(english:desc["english"]);

 summary["english"] = "Finds .mp3, .avi and .wav files";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"This script is Copyright (C) 2003 - 2007 Tenable Network Security");
 family["english"] = "Peer-To-Peer File Sharing";
 script_family(english:family["english"]);

 script_dependencies("smb_accessible_shares.nasl","smb_hotfixes.nasl", "smb_enum_files.nasl","smb_enum_softwares.nasl");
 script_require_keys("SMB/shares");
 script_require_ports(139, 445);
 exit(0);
}


include("smb_func.inc");
include("smb_hotfixes.inc");

# Here we go
#		

monitored_file_ext_type = make_list("mp3","mpg","mpeg","wav","ogg","avi","wma","divx","xvid","mkv","mp4","asf","mka", "vob");

# poular list of DVD copying software

software_list	= make_list (  "DVD Ripper",
			       "XviD MPEG4 Video Codec",
			       "DivX Converter",
			       "DivX Codec",
			       "DVD-CLONER",
			       "1Click DVD Copy",
			       "DVD Wizard PRO",
			       "Gordian Knot",
			       "CloneDVD"); 		

name = kb_smb_name();
login = kb_smb_login();
pass =  kb_smb_password();
dom = kb_smb_domain();

report = NULL;
shares = get_kb_list("SMB/shares");
if(!isnull(shares))  shares = make_list(shares);
else
exit(0);

systemroot = hotfix_get_systemroot();
if ( ! systemroot ) exit(0); 
systemroot_share = ereg_replace(pattern:"^([A-Z]):.*", string:systemroot, replace:"\1$");
systemroot_path = ereg_replace(pattern:"^[A-Z]:(.*)", string:systemroot, replace:"\1");
systemroot_path = tolower(str_replace(string:systemroot_path, find:'\\', replace:'\\\\'));



softwares = get_kb_list ("SMB/Registry/HKLM/SOFTWARE/Microsoft/Windows/CurrentVersion/Uninstall/*/DisplayName");
if (!isnull(softwares)) softwares = make_list(softwares);
else softwares = make_list();
count = 0;
flag = 0;

# Get the list of files on each share

foreach share (shares)
{
  file_list = NULL;
  flag = 0;
  if ( share != "ADMIN$" )
  {
    foreach ext (monitored_file_ext_type)
    {	
    if (isnull(file_list)) {
		k = get_kb_list("SMB/"+share+"/content/extensions/"+ext);
		if ( !isnull(k) ) 
			file_list = make_list(k);
		}
    else {
		k = get_kb_list("SMB/"+share+"/content/extensions/"+ext);
		if ( !isnull(k) ) 
			file_list = make_list(file_list, k);
	} 
    }
    if (max_index(file_list) > 0)
    {		 
	foreach file (file_list)
	{
 	 if ( share == systemroot_share &&
	      tolower(file) =~ "^" + systemroot_path )  continue;	
             
	 if ( flag == 0 )
	 {
      	   report += " + " + share + ' :\n\n';
	   flag ++;
	 }
  	 report += file + '\n';
	 count ++;
   	 if ( count > 255 ) break;
	}
      if ( count != 0 ) report += '\n';
    } 
  }
  if ( count > 255 ) break;
} 

# Check if any DVD copying software's or codecs are installed

installed_software = NULL;
	
if(max_index(softwares) > 0)
{
  foreach software (softwares)
   {
     foreach ks (software_list)
	{
	  if (ks >< software)
	  {
	    installed_software += software + '\n'; 	
	  }
	}		   	
   }
}

if(report != NULL)
 {
  report = "Plugin output : 

Here is a list of files which have been found on the remote SMB shares.
Some of these files may contain copyrighted materials, such as commercial
movies or music files.

If any of this file actually contains copyrighted material and if
they are freely swapped around, your organization might be held liable
for copyright infringement by associations such as the RIAA or the MPAA."+ '\n\n'+

  report + '\n';

 if (!isnull(installed_software))
 { 
  report += "In addition to the files, following softwares which can be used to copy copyrighted DVDs are installed : "+ 
 	     '\n\n' 
	     + installed_software + '\n' +
	     "If the use of these software applications is not inline with your corporate policy, you should un-install them."+' \n';
 }	

  report = string(desc["english"],report);
  security_warning(port:kb_smb_transport(), data:report);
 }

