#
# (C) Tenable Network Security
#


if(description)
{
 script_id(21655);
 script_version("$Revision: 1.2 $");

 script_cve_id("CVE-2003-0813", "CVE-2004-0116", "CVE-2003-0807", "CVE-2004-0124");
 script_bugtraq_id(10121, 10123, 10127, 8811);
 script_xref(name:"IAVA", value:"2004-A-0005");
 script_xref(name:"OSVDB", value:"5245");
 script_xref(name:"OSVDB", value:"5246");
 script_xref(name:"OSVDB", value:"5247");

 name["english"] = "Microsoft Hotfix KB828741 (network check)";

 script_name(english:name["english"]);

 desc["english"] = "
Synopsis :

Arbitrary code can be executed on the remote host.

Description :

The remote host has multiple bugs in its RPC/DCOM implementation (828741).

An attacker may exploit one of these flaws to execute arbitrary code on the
remote system.

Solution : 

Microsoft has released a set of patches for Windows NT, 2000, XP and 2003 :

http://www.microsoft.com/technet/security/bulletin/ms04-012.mspx

Risk factor : 

Critical / CVSS Base Score : 10.0
(CVSS2#AV:N/AC:L/Au:N/C:C/I:C/A:C)";

 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for ms04-012";

 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Windows";
 script_family(english:family["english"]);
 script_dependencies("smb_nativelanman.nasl");
 script_require_keys("Host/OS/smb");
 script_require_ports(135, 139, 445);
 exit(0);
}


include ('smb_func.inc');


function SCMActivatorGetClassObject (socket, type)
{
 local_var data, ret, resp, code;

 data =
	# struct 1
	raw_word(w:0) +
	raw_word(w:0) +
	raw_dword(d:0) +
	raw_dword(d:0) +
	raw_dword(d:0) +
	raw_word(w:0) +
	raw_word(w:0) +
	raw_dword(d:0) + raw_dword(d:0) +
	raw_dword(d:0) +

	# struct 2
	raw_dword(d:0) +
	raw_dword(d:0) +

	# struct4
	raw_dword(d:0x20000) +
	raw_dword(d:4) +
	raw_dword(d:4) +
	raw_dword(d:0);
	
 ret = dce_rpc_request (code:0x03, data:data);
 send (socket:socket, data:ret);
 resp = recv (socket:socket, length:4096);
 if (isnull(resp))
   return 0;

 if (strlen(resp) < 32 || ord(resp[2]) != 3)
   return 0;

 # 0x80010110 -> bad dcom header. Path should check it is a local call first and return ACCESS_DENIED
 code = get_dword (blob:resp, pos:24);
 if (code == 0x80010110)
   return 1;

 return 0;
}

 
os = get_kb_item("Host/OS/smb");
if ( "Windows" >!< os ) exit (0);


port = 135;

if ( ! get_port_state(port) ) exit(0);
soc = open_sock_tcp (port);
if (!soc) exit (0);

ret = dce_rpc_bind(cid:session_get_cid(), uuid:"00000136-0000-0000-c000-000000000046", vers:0);
send (socket:soc, data:ret);
resp = recv (socket:soc, length:4096);

if (!resp)
{
 close (soc);
 exit (0); 
}

ret = dce_rpc_parse_bind_ack (data:resp);
if (isnull (ret) || (ret != 0))
{
 close (soc);
 exit (0);
}


ret = SCMActivatorGetClassObject (socket:soc);
if (ret == 1)
  security_hole(port);
