#
# (C) Tenable Network Security, Inc.
#

if(description)
{
 script_id(25035);
 script_version("$Revision: 1.5 $");
 script_bugtraq_id(23470);
 script_cve_id("CVE-2007-1748");
 name["english"] = "Microsoft Windows Domain Name Server Service Remote Procedure Call Interface Vulnerability";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

Arbitrary code can be executed on the remote host due to the DNS service.

Description :

The remote host has the Windows DNS server installed.

There is a flaw in the remote version of this server which may allow an
attacker to execute arbitrary code on the remote host with SYSTEM
privileges. To exploit this flaw, an attacker needs to connect to the
DNS server RPC interface and send malformed RPC queries.

Solution : 

Microsoft has released the security advisory 935964 detailing 
a method to disable the RPC interface of the remote service.

Apply this workaround until Microsoft releases a patch for this
issue.

See also :

http://www.microsoft.com/technet/security/advisory/935964.mspx

Risk factor : 

Critical / CVSS Base Score : 10.0
(CVSS2#AV:N/AC:L/Au:N/C:C/I:C/A:C)";

 script_description(english:desc["english"]);
 
 summary["english"] = "Checks if the MS DNS server has its RPC interface enabled";

 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc.");
 family["english"] = "Windows";
 script_family(english:family["english"]);
 
 script_dependencies("dcetest.nasl", "smb_nativelanman.nasl");
 script_require_keys("Host/OS/smb");
 script_require_keys("Services/DCE/50abc2a4-574d-40b3-9d66-ee4fd5fba076");
 exit(0);
}


#deprecated
exit (0);
