#
# This script was written by Tenable Network Security
#
# This script is released under Tenable Plugins License
#

if(description)
{
 script_id(11423);
 script_bugtraq_id(7146);
 script_cve_id("CVE-2003-0010");
 script_version("$Revision: 1.19 $");

 name["english"] = "Flaw in Windows Script Engine (Q814078)";

 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

Arbitrary code can be executed on the remote host through the web client.

Description :

The remote host is vulnerable to a flaw in the Windows Script Engine,
which provides Windows with the ability to execute script code.

To exploit this flaw, an attacker would need to lure one user on this
host to visit a rogue website or to send him an HTML e-mail with a
malicious code in it.

Solution : 

Microsoft has released a set of patches for Windows NT, 2000 and XP :

http://www.microsoft.com/technet/security/bulletin/ms03-008.mspx

Risk factor :

Medium / CVSS Base Score : 6 
(AV:R/AC:H/Au:NR/C:P/A:P/I:P/B:N)";

 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for MS Hotfix Q814078";

 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2005 Tenable Network Security");
 family["english"] = "Windows : Microsoft Bulletins";
 script_family(english:family["english"]);
 
 script_dependencies("smb_hotfixes.nasl");
 script_require_keys("SMB/Registry/Enumerated");
 script_require_ports(139, 445);
 exit(0);
}

include("smb_func.inc");
include("smb_hotfixes.inc");
include("smb_hotfixes_fcheck.inc");


if ( hotfix_check_sp(xp:2, win2k:4) <= 0 ) exit(0);

if (is_accessible_share())
{
 if ( hotfix_is_vulnerable (os:"5.1", file:"Jscript.dll", version:"5.6.0.8513", dir:"\system32") ||
      hotfix_is_vulnerable (os:"5.0", file:"Jscript.dll", version:"5.5.0.8513", min_version:"5.5.0.0", dir:"\system32") ||
      hotfix_is_vulnerable (os:"5.0", file:"Jscript.dll", version:"5.1.0.813", dir:"\system32") )
   security_warning (get_kb_item("SMB/transport"));
 
 hotfix_check_fversion_end();
 exit (0);
}
else if ( hotfix_missing(name:"814078") > 0 && 
          hotfix_missing(name:"917344") > 0 )
  hotfix_security_warning();
