#
# (C) Tenable Network Security
#

if(description)
{
 script_id(23643);
 script_version("$Revision: 1.4 $");

 script_cve_id("CVE-2006-4688", "CVE-2006-4689");
 script_bugtraq_id(20984, 21023);

 name["english"] = "Vulnerability in the Client Service for NetWare Could Allow Remote Code Execution (923980)";

 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

A flaw in the client service for NetWare may allow an attacker to execute
arbitrary code on the remote host.

Description :

The remote host contains a version of the Client Service for NetWare which 
is vulnerable to a buffer overflow. An attacker may exploit this to 
cause a denial of service by sending a malformed IPX packet to the remote
host, or to execute arbitrary code by exploiting a flaw in the NetWare client.


Solution : 

Microsoft has released a set of patches for Windows 2000, XP and 2003 :

http://www.microsoft.com/technet/security/bulletin/ms06-066.mspx

Risk factor :

High / CVSS Base Score : 7.5
(CVSS2#AV:N/AC:L/Au:N/C:P/I:P/A:P)";



 script_description(english:desc["english"]);
 
 summary["english"] = "Determines the presence of update 923980";

 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2006 Tenable Network Security");
 family["english"] = "Windows : Microsoft Bulletins";
 script_family(english:family["english"]);
 
 script_dependencies("smb_hotfixes.nasl");
 script_require_keys("SMB/Registry/Enumerated");
 script_require_ports(139, 445);
 exit(0);
}

include("smb_func.inc");
include("smb_hotfixes.inc");
include("smb_hotfixes_fcheck.inc");


if ( hotfix_check_sp(xp:3, win2003:2, win2k:6) <= 0 ) exit(0);

if (is_accessible_share())
{
 if ( hotfix_is_vulnerable (os:"5.2", sp:0, file:"nwrdr.sys", version:"5.2.3790.588", dir:"\system32\drivers") ||
      hotfix_is_vulnerable (os:"5.2", sp:1, file:"nwrdr.sys", version:"5.2.3790.2783", dir:"\system32\drivers") ||
      hotfix_is_vulnerable (os:"5.1", sp:2, file:"nwrdr.sys", version:"5.1.2600.3015", dir:"\system32\drivers") ||
      hotfix_is_vulnerable (os:"5.0",       file:"nwrdr.sys", version:"5.0.2195.7110", dir:"\system32\drivers") )
   hotfix_security_hole();
 
 hotfix_check_fversion_end(); 
 exit (0);
}
else if ( hotfix_missing(name:"923980") > 0 ) hotfix_security_hole();
