#
# (C) Tenable Network Security
#

if(description)
{
 script_id(25022);
 script_version("$Revision: 1.6 $");

 script_cve_id("CVE-2007-1204");
 script_bugtraq_id(23371);
 script_xref(name:"OSVDB", value:"34010");

 name["english"] = "Vulnerability in Universal Plug and Play Could Allow Remote Code Execution (931261)";

 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

Arbitrary code can be executed on the remote host due to a flaw in the 
Plug-And-Play service.

Description :

The remote version of Windows contains a flaw in the http request 
handler the Plug and Play service which may allow an attacker to 
execute arbitrary code on the remote host with the service privileges.

Solution : 

Microsoft has released a set of patches for Windows XP :

http://www.microsoft.com/technet/security/bulletin/ms07-019.mspx

Risk factor : 

Medium / CVSS Base Score : 6.8
(CVSS2#AV:A/AC:H/Au:N/C:C/I:C/A:C)";


 script_description(english:desc["english"]);
 
 summary["english"] = "Determines the presence of update 931261";

 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc");
 family["english"] = "Windows : Microsoft Bulletins";
 script_family(english:family["english"]);
 
 script_dependencies("smb_hotfixes.nasl");
 script_require_keys("SMB/Registry/Enumerated");
 script_require_ports(139, 445);
 exit(0);
}

include("smb_func.inc");
include("smb_hotfixes.inc");
include("smb_hotfixes_fcheck.inc");


if ( hotfix_check_sp(xp:3) <= 0 ) exit(0);
 
if (is_accessible_share())
{
 if ( hotfix_is_vulnerable (os:"5.1", sp:2, file:"Upnphost.dll", version:"5.1.2600.3077", dir:"\system32") )
   hotfix_security_warning();
 
 hotfix_check_fversion_end(); 
 exit (0);
}
else if ( hotfix_missing(name:"931261") > 0 ) 
  hotfix_security_warning();
