#
# (C) Tenable Network Security
#

if(description)
{
 script_id(25168);
 script_version("$Revision: 1.5 $");

 script_cve_id("CVE-2007-1748");
 script_bugtraq_id(23470);

 name["english"] = "Vulnerability in Windows DNS RPC Interface Could Allow Remote Code Execution (935966)";

 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

Arbitrary code can be executed on the remote host due to the DNS service.

Description :

The remote host has the Windows DNS server installed.

There is a flaw in the remote version of this server which may allow an
attacker to execute arbitrary code on the remote host with SYSTEM
privileges. To exploit this flaw, an attacker needs to connect to the
DNS server RPC interface and send malformed RPC queries.

Solution : 

Microsoft has released patches for Windows 2000 and 2003 Server :

http://www.microsoft.com/technet/security/Bulletin/MS07-029.mspx

Risk factor : 

Critical / CVSS Base Score : 10.0
(CVSS2#AV:N/AC:L/Au:N/C:C/I:C/A:C)";



 script_description(english:desc["english"]);
 
 summary["english"] = "Determines the presence of update 935966";

 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Windows : Microsoft Bulletins";
 script_family(english:family["english"]);
 
 script_dependencies("smb_hotfixes.nasl");
 script_require_keys("SMB/Registry/Enumerated");
 script_require_ports(139, 445);
 exit(0);
}

include("smb_func.inc");
include("smb_hotfixes.inc");
include("smb_hotfixes_fcheck.inc");


if ( hotfix_check_sp(win2003:3, win2k:6) <= 0 ) exit(0);
if ( hotfix_check_sp(win2k:6) > 0)
{
 if ( hotfix_check_nt_server() <= 0 ) 
   exit(0); 
} 

if (is_accessible_share())
{
 if ( hotfix_is_vulnerable (os:"5.2", sp:1, file:"Dns.exe", version:"5.2.3790.2915", dir:"\system32") ||
      hotfix_is_vulnerable (os:"5.2", sp:2, file:"Dns.exe", version:"5.2.3790.4059", dir:"\system32") ||
      hotfix_is_vulnerable (os:"5.0", file:"Dns.exe", version:"5.0.2195.7135", dir:"\system32") )
   hotfix_security_hole();
 
 hotfix_check_fversion_end(); 
 exit (0);
}
#else if ( hotfix_missing(name:"935966") > 0 ) hotfix_security_hole();
