#
# (C) Tenable Network Security
#

if(description)
{
 script_id(25484);
 script_version("$Revision: 1.4 $");

 script_cve_id("CVE-2007-2218");
 script_bugtraq_id(24416);

 name["english"] = "Vulnerability in the Windows Schannel Security Package Could Allow Remote Code Execution (935840)";

 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

Arbitrary code can be executed on the remote host through the web browser.

Description :

The remote host is running a version of Windows which is vulnerable to a bug in 
the SSL/TLS server-key exchange handling routine which may allow an attacker to execute 
arbitrary code on the remote host by luring a user on the remote host 
into visiting a rogue web site.

On Windows 2000 and 2003 this vulnerability only results in a crash of the web browser.
Solution : 

Microsoft has released a set of patches for Windows 2000, XP, 2003 :

http://www.microsoft.com/technet/security/Bulletin/MS07-031.mspx

Risk factor : 

High / CVSS Base Score : 9.3
(CVSS2#AV:N/AC:M/Au:N/C:C/I:C/A:C)";


 script_description(english:desc["english"]);
 
 summary["english"] = "Determines the presence of update 935840";

 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc");
 family["english"] = "Windows : Microsoft Bulletins";
 script_family(english:family["english"]);
 
 script_dependencies("smb_hotfixes.nasl");
 script_require_keys("SMB/Registry/Enumerated");
 script_require_ports(139, 445);
 exit(0);
}



include("smb_hotfixes_fcheck.inc");
include("smb_hotfixes.inc");
include("smb_func.inc");

if ( hotfix_check_sp(xp:3, win2003:3, win2k:6) <= 0 ) exit(0);

if (is_accessible_share())
{
 if ( hotfix_is_vulnerable (os:"5.2", sp:2, file:"Schannel.dll", version:"5.2.3790.4068", dir:"\System32") ||
      hotfix_is_vulnerable (os:"5.2", sp:1, file:"Schannel.dll", version:"5.2.3790.2924", dir:"\System32") ||
      hotfix_is_vulnerable (os:"5.1", file:"Schannel.dll", version:"5.1.2600.3126", dir:"\System32") ||
      hotfix_is_vulnerable (os:"5.0", file:"Schannel.dll", version:"5.1.2195.7136", dir:"\System32") )
   hotfix_security_hole();
 
 hotfix_check_fversion_end(); 
 exit (0);
}
else
{
 if ( hotfix_missing(name:"935840") > 0 )
   hotfix_security_hole();
}
