#
# (C) Tenable Network Security
#

if(description)
{
 script_id(25880);
 script_version("$Revision: 1.7 $");
 script_cve_id("CVE-2007-2223");
 script_bugtraq_id(25301);

 name["english"] = "Vulnerability in Microsoft XML Core Services Could Allow Remote Code Execution (936227)";

 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

Arbitrary code can be executed on the remote host through the web or
email client. 

Description :

The remote host is running a version of Windows which contains a flaw
in the Windows XML Core Services..

An attacker may be able to execute arbitrary code on the remote host
by constructing a malicious script and enticing a victim to visit a
web site or view a specially-crafted email message.

Solution : 

Microsoft has released a set of patches for Windows 2000, XP, 2003 
and Vista:

http://www.microsoft.com/technet/security/Bulletin/MS07-042.mspx

Risk factor : 

High / CVSS Base Score : 9.3
(CVSS2#AV:N/AC:M/Au:N/C:C/I:C/A:C)";


 script_description(english:desc["english"]);
 
 summary["english"] = "Determines the presence of update 936227";

 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Windows : Microsoft Bulletins";
 script_family(english:family["english"]);
 
 script_dependencies("smb_hotfixes.nasl");
 script_require_keys("SMB/Registry/Enumerated");
 script_require_ports(139, 445);
 exit(0);
}


include("smb_hotfixes_fcheck.inc");
include("smb_hotfixes.inc");
include("smb_func.inc");


if ( hotfix_check_sp(xp:3, win2003:3, win2k:6, vista:1) > 0 ) 
{
 if (is_accessible_share())
 {
  if ( ( hotfix_check_fversion(file:"system32\Msxml3.dll", version:"8.90.1101.0") == HCF_OLDER ) ||
       ( hotfix_check_fversion(file:"system32\Msxml4.dll", version:"4.20.9847.0") == HCF_OLDER ) ||
       ( hotfix_check_fversion(file:"system32\Msxml5.dll", version:"5.20.1081.0") == HCF_OLDER ) ||
       ( hotfix_check_fversion(file:"system32\Msxml6.dll", version:"6.10.1200.0") == HCF_OLDER ) )
  {
    hotfix_security_hole();
    exit(0);
  }
 
  hotfix_check_fversion_end(); 
 }
 else if ( hotfix_missing(name:"936021") > 0 )
 {
   hotfix_security_hole();
   exit(0);
 }
}


office_version = hotfix_check_office_version ();
if ( !office_version )
  exit(0);

rootfile = hotfix_get_commonfilesdir();
if ( ! rootfile )
  exit(0);

if ( "11.0" >!< office_version )
  exit (0);

if (!is_accessible_share())
  exit (0);

if ( hotfix_check_fversion(path:rootfile, file:"\Microsoft Shared\Office11\msxml5.dll", version:"5.20.1081.0") == HCF_OLDER )
  hotfix_security_hole();
