#
# (C) Tenable Network Security
#

if(description)
{
 script_id(26017);
 script_version("$Revision: 1.3 $");

 script_cve_id("CVE-2007-3040");
 script_bugtraq_id(25566);
 
 name["english"] = "Vulnerability in Microsoft Agent Could Allow Remote Code Execution (938827)";

 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

Arbitrary code can be executed on the remote host through the web or
email client. 

Description :

The remote version of Windows contains a flaw in the Microsoft Agent service 
which may allow an attacker to execute code on the remote host.

To exploit this flaw, an attacker would need to set up a rogue web site and 
lure a victim on the remote host into visiting it.

Solution : 

Microsoft has released a set of patches for Windows 2000 :

http://www.microsoft.com/technet/security/bulletin/ms07-051.mspx

Risk factor : 

High / CVSS Base Score : 9.3
(CVSS2#AV:N/AC:M/Au:N/C:C/I:C/A:C)";


 script_description(english:desc["english"]);
 
 summary["english"] = "Determines the presence of update 938827";

 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc");
 family["english"] = "Windows : Microsoft Bulletins";
 script_family(english:family["english"]);
 
 script_dependencies("smb_hotfixes.nasl");
 script_require_keys("SMB/Registry/Enumerated");
 script_require_ports(139, 445);
 exit(0);
}


include("smb_hotfixes_fcheck.inc");
include("smb_hotfixes.inc");
include("smb_func.inc");


if ( hotfix_check_sp(win2k:6) <= 0 ) exit(0);

if (is_accessible_share())
{
 if ( hotfix_is_vulnerable (os:"5.0", file:"Agentdpv.dll", version:"2.0.0.3426", dir:"\msagent") )
   hotfix_security_hole();
 
 hotfix_check_fversion_end(); 
 exit (0);
}
else if ( hotfix_missing(name:"938827") > 0 )
	 hotfix_security_hole();


