#
# (C) Tenable Network Security
#
if(description)
{
 script_id(31041);
 script_version("$Revision: 1.4 $");

 script_cve_id("CVE-2008-0080");
 script_bugtraq_id(27670);

 name["english"] = "Vulnerability in WebDAV Mini-Redirector Could Allow Remote Code Execution (946026)";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

It is possible to execute arbitrary code on the remote host.

Description :

The remote host is running a version of Windows which is vulnerable
to a flaw which may allow an attacker to execute arbitrary code on the remote
host.

Specifically, the remote version of Windows is vulnerable to a flaw in the
WebDav Mini-Redirector handler. By sending a specially malformed message,
an attacker may be able to take the complete control of the remote system.


Solution : 

Microsoft has released a set of patches for Windows XP, 2003 and Vista :

http://www.microsoft.com/technet/security/bulletin/ms08-007.mspx

Risk factor :

High / CVSS Base Score : 7.6 
(CVSS2#AV:N/AC:H/Au:N/C:C/I:C/A:C)";

 script_description(english:desc["english"]);
 
 summary["english"] = "Determines if hotfix 946026 has been installed";

 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2008 Tenable Network Security");
 family["english"] = "Windows : Microsoft Bulletins";
 script_family(english:family["english"]);
 
 script_dependencies("smb_hotfixes.nasl");
 script_require_keys("SMB/Registry/Enumerated");
 script_require_ports(139, 445);
 exit(0);
}

include("smb_func.inc");
include("smb_hotfixes.inc");
include("smb_hotfixes_fcheck.inc");

if ( hotfix_check_sp(xp:3, win2003:3, vista:1) <= 0 ) exit(0);

if (is_accessible_share())
{
 if ( hotfix_is_vulnerable (os:"6.0", sp:0, file:"mrxdav.sys", version:"6.0.6000.20751", min_version:"6.0.6000.20000", dir:"\system32\drivers") ||
      hotfix_is_vulnerable (os:"6.0", sp:0, file:"mrxdav.sys", version:"6.0.6000.16626", dir:"\system32\drivers") ||
      hotfix_is_vulnerable (os:"5.2", sp:2, file:"mrxdav.sys", version:"5.2.3790.4206", dir:"\system32\drivers") ||
      hotfix_is_vulnerable (os:"5.2", sp:1, file:"mrxdav.sys", version:"5.2.3790.3060", dir:"\system32\drivers") ||
      hotfix_is_vulnerable (os:"5.1", sp:2, file:"mrxdav.sys", version:"5.1.2600.3276", dir:"\system32\drivers") )
   hotfix_security_hole();
 
 hotfix_check_fversion_end(); 
 exit (0);
}
else if ( hotfix_missing(name:"946026") > 0  )
	hotfix_security_hole();

