#
# (C) Tenable Network Security
#

 desc["english"] = "
Synopsis :

It is possible to log into the remote host. 

Description :

The remote host is running one of the Microsoft Windows operating
systems.  It was possible to log into it using a NULL session.

A NULL session (no login/password) allows to get information about
the remote host.

See also :

http://support.microsoft.com/support/kb/articles/Q143/4/74.ASP
http://support.microsoft.com/support/kb/articles/Q246/2/61.ASP

Risk factor :

None";


if(description)
{
 script_id(26920);
 script_bugtraq_id(494);
 script_version ("$Revision: 1.1 $");
 script_cve_id("CVE-2002-1117");
 name["english"] = "SMB NULL session";
 
 script_name(english:name["english"]);
 
 script_description(english:desc["english"]);
 
 summary["english"] = "Attempts to log into the remote host using a NULL session";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc");
 family["english"] = "Windows";
 script_family(english:family["english"]);
 
 script_dependencies("smb_login.nasl");
 script_require_keys("SMB/null_session_enabled");
 exit(0);
}

include("smb_func.inc");

val = get_kb_item("SMB/null_session_enabled");

if (val)
  security_note(kb_smb_transport());

