#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(22943);
 script_version ("$Revision: 1.7 $");
 name["english"] = "Solaris 10 (sparc) : 115610-25";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is missing Sun Security Patch number 115610-25
(Sun Java(TM) System Administration Server 5.2 patch 6: Solaris sparc).

Date this patch was last updated by Sun : Fri Sep 21 14:38:25 MDT 2007

You should install this patch for your system to be up-to-date.

Solution : http://sunsolve.sun.com/search/document.do?assetkey=1-21-115610-25-1
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for patch 115610-25"; 
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Solaris Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Solaris/showrev");
 exit(0);
}



include("solaris.inc");

e +=  solaris_check_patch(release:"5.10", arch:"sparc", patch:"115610-25", obsoleted_by:"", package:"SUNWasha", version:"5.2,REV=2003.05.22");
e +=  solaris_check_patch(release:"5.10", arch:"sparc", patch:"115610-25", obsoleted_by:"", package:"SUNWasvc", version:"5.2,REV=2003.05.22");
e +=  solaris_check_patch(release:"5.10", arch:"sparc", patch:"115610-25", obsoleted_by:"", package:"SUNWasvcp", version:"5.2,REV=2003.05.22");
e +=  solaris_check_patch(release:"5.10", arch:"sparc", patch:"115610-25", obsoleted_by:"", package:"SUNWasvr", version:"5.2,REV=2003.05.22");
e +=  solaris_check_patch(release:"5.10", arch:"sparc", patch:"115610-25", obsoleted_by:"", package:"SUNWasvu", version:"5.2,REV=2003.05.22");
if ( e < 0 ) { 
	if ( NASL_LEVEL < 3000 ) 
	   security_hole(0);
	else  
	   security_hole(port:0, extra:solaris_get_report());
	exit(0); 
} 
