#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(22244);
 script_version ("$Revision: 1.28 $");
 name["english"] = "Solaris 10 (sparc) : 119254-52";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is missing Sun Security Patch number 119254-52
(SunOS 5.10: Install and Patch Utilities Patch).

Date this patch was last updated by Sun : Fri Feb 29 13:38:50 MST 2008

You should install this patch for your system to be up-to-date.

Solution : http://sunsolve.sun.com/search/document.do?assetkey=1-21-119254-52-1
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for patch 119254-52"; 
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2008 Tenable Network Security");
 family["english"] = "Solaris Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Solaris/showrev");
 exit(0);
}



include("solaris.inc");

e +=  solaris_check_patch(release:"5.10", arch:"sparc", patch:"119254-52", obsoleted_by:"", package:"SUNWinstall-patch-utils-root", version:"11.10,REV=2005.01.09.23.05");
e +=  solaris_check_patch(release:"5.10", arch:"sparc", patch:"119254-52", obsoleted_by:"", package:"SUNWpkgcmdsu", version:"11.11,REV=2005.01.09.23.05");
e +=  solaris_check_patch(release:"5.10", arch:"sparc", patch:"119254-52", obsoleted_by:"", package:"SUNWswmt", version:"11.10,REV=2005.01.10.17.19");
if ( e < 0 ) { 
	if ( NASL_LEVEL < 3000 ) 
	   security_hole(0);
	else  
	   security_hole(port:0, extra:solaris_get_report());
	exit(0); 
} 
