#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(26984);
 script_version ("$Revision: 1.4 $");
 name["english"] = "Solaris 10 (sparc) : 125136-07";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is missing Sun Security Patch number 125136-07
(JavaSE 6: update 5 patch (equivalent to JDK 6u5)).

Date this patch was last updated by Sun : Wed Feb 27 13:35:27 MST 2008

You should install this patch for your system to be up-to-date.

Solution : http://sunsolve.sun.com/search/document.do?assetkey=1-21-125136-07-1
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for patch 125136-07"; 
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2008 Tenable Network Security");
 family["english"] = "Solaris Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Solaris/showrev");
 exit(0);
}



include("solaris.inc");

e +=  solaris_check_patch(release:"5.10", arch:"sparc", patch:"125136-07", obsoleted_by:"", package:"SUNWj6cfg", version:"1.6.0,REV=2006.11.29.05.57");
e +=  solaris_check_patch(release:"5.10", arch:"sparc", patch:"125136-07", obsoleted_by:"", package:"SUNWj6dev", version:"1.6.0,REV=2006.11.29.05.57");
e +=  solaris_check_patch(release:"5.10", arch:"sparc", patch:"125136-07", obsoleted_by:"", package:"SUNWj6dmo", version:"1.6.0,REV=2006.11.29.05.57");
e +=  solaris_check_patch(release:"5.10", arch:"sparc", patch:"125136-07", obsoleted_by:"", package:"SUNWj6jmp", version:"1.6.0,REV=2006.12.07.19.24");
e +=  solaris_check_patch(release:"5.10", arch:"sparc", patch:"125136-07", obsoleted_by:"", package:"SUNWj6man", version:"1.6.0,REV=2006.12.07.16.37");
e +=  solaris_check_patch(release:"5.10", arch:"sparc", patch:"125136-07", obsoleted_by:"", package:"SUNWj6rt", version:"1.6.0,REV=2006.11.29.05.57");
if ( e < 0 ) { 
	if ( NASL_LEVEL < 3000 ) 
	   security_hole(0);
	else  
	   security_hole(port:0, extra:solaris_get_report());
	exit(0); 
} 
