#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(26989);
 script_version ("$Revision: 1.5 $");
 name["english"] = "Solaris 10 (sparc) : 125719-08";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is missing Sun Security Patch number 125719-08
(X11 6.8.0: Xorg server patch).

Date this patch was last updated by Sun : Fri Feb 15 10:11:53 MST 2008

You should install this patch for your system to be up-to-date.

Solution : http://sunsolve.sun.com/search/document.do?assetkey=1-21-125719-08-1
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for patch 125719-08"; 
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2008 Tenable Network Security");
 family["english"] = "Solaris Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Solaris/showrev");
 exit(0);
}



include("solaris.inc");

e +=  solaris_check_patch(release:"5.10", arch:"sparc", patch:"125719-08", obsoleted_by:"", package:"SUNWxorg-cfg", version:"6.6.2.7600,REV=0.2007.06.22");
e +=  solaris_check_patch(release:"5.10", arch:"sparc", patch:"125719-08", obsoleted_by:"", package:"SUNWxorg-client-docs", version:"6.8.2.5.10.0110,REV=0.2005.06.21");
e +=  solaris_check_patch(release:"5.10", arch:"sparc", patch:"125719-08", obsoleted_by:"", package:"SUNWxorg-client-programs", version:"6.8.2.5.10.0110,REV=0.2005.06.21");
e +=  solaris_check_patch(release:"5.10", arch:"sparc", patch:"125719-08", obsoleted_by:"", package:"SUNWxorg-devel-docs", version:"6.8.2.5.10.0110,REV=0.2005.06.21");
e +=  solaris_check_patch(release:"5.10", arch:"sparc", patch:"125719-08", obsoleted_by:"", package:"SUNWxorg-doc", version:"6.6.2.7600,REV=0.2007.06.22");
e +=  solaris_check_patch(release:"5.10", arch:"sparc", patch:"125719-08", obsoleted_by:"", package:"SUNWxorg-graphics-ddx", version:"6.6.2.7600,REV=0.2007.06.22");
e +=  solaris_check_patch(release:"5.10", arch:"sparc", patch:"125719-08", obsoleted_by:"", package:"SUNWxorg-server", version:"6.6.2.7600,REV=0.2007.06.22");
if ( e < 0 ) { 
	if ( NASL_LEVEL < 3000 ) 
	   security_hole(0);
	else  
	   security_hole(port:0, extra:solaris_get_report());
	exit(0); 
} 
