#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(31333);
 script_version ("$Revision: 1.1 $");
 name["english"] = "Solaris 10 (sparc) : 137080-01";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is missing Sun Security Patch number 137080-01
(SunOS 5.10: libpng Patch).

Date this patch was last updated by Sun : Fri Feb 08 07:20:48 MST 2008

You should install this patch for your system to be up-to-date.

Solution : http://sunsolve.sun.com/search/document.do?assetkey=1-21-137080-01-1
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for patch 137080-01"; 
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2008 Tenable Network Security");
 family["english"] = "Solaris Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Solaris/showrev");
 exit(0);
}



include("solaris.inc");

e +=  solaris_check_patch(release:"5.10", arch:"sparc", patch:"137080-01", obsoleted_by:"", package:"SUNWpng", version:"20.2.6.0,REV=10.0.3.2004.12.15.14.11");
e +=  solaris_check_patch(release:"5.10", arch:"sparc", patch:"137080-01", obsoleted_by:"", package:"SUNWpng-devel", version:"20.2.6.0,REV=10.0.3.2004.12.15.14.11");
e +=  solaris_check_patch(release:"5.10", arch:"sparc", patch:"137080-01", obsoleted_by:"", package:"SUNWpngS", version:"20.2.6.0,REV=10.0.3.2004.12.15.14.11");
if ( e < 0 ) { 
	if ( NASL_LEVEL < 3000 ) 
	   security_hole(0);
	else  
	   security_hole(port:0, extra:solaris_get_report());
	exit(0); 
} 
