#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(20055);
 script_version ("$Revision: 1.14 $");
 name["english"] = "Solaris 10 (i386) : 119214-16";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is missing Sun Security Patch number 119214-16
(NSS_NSPR_JSS 3.11.8_x86: NSPR 4.6.8 / NSS 3.11.8 / JSS 4.2.5).

Date this patch was last updated by Sun : Mon Feb 04 08:37:08 MST 2008

You should install this patch for your system to be up-to-date.

Solution : http://sunsolve.sun.com/search/document.do?assetkey=1-21-119214-16-1
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for patch 119214-16"; 
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2008 Tenable Network Security");
 family["english"] = "Solaris Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Solaris/showrev");
 exit(0);
}



include("solaris.inc");

e +=  solaris_check_patch(release:"5.10_x86", arch:"i386", patch:"119214-16", obsoleted_by:"", package:"SUNWjss", version:"4.0,REV=2004.11.05.03.05");
e +=  solaris_check_patch(release:"5.10_x86", arch:"i386", patch:"119214-16", obsoleted_by:"", package:"SUNWpr", version:"4.5.1,REV=2004.11.05.03.44");
e +=  solaris_check_patch(release:"5.10_x86", arch:"i386", patch:"119214-16", obsoleted_by:"", package:"SUNWprd", version:"4.5.1,REV=2004.11.05.03.44");
e +=  solaris_check_patch(release:"5.10_x86", arch:"i386", patch:"119214-16", obsoleted_by:"", package:"SUNWtls", version:"3.9.5,REV=2005.01.14.19.03");
e +=  solaris_check_patch(release:"5.10_x86", arch:"i386", patch:"119214-16", obsoleted_by:"", package:"SUNWtlsd", version:"3.9.5,REV=2005.01.14.19.03");
e +=  solaris_check_patch(release:"5.10_x86", arch:"i386", patch:"119214-16", obsoleted_by:"", package:"SUNWtlsu", version:"3.9.5,REV=2005.01.14.19.03");
if ( e < 0 ) { 
	if ( NASL_LEVEL < 3000 ) 
	   security_hole(0);
	else  
	   security_hole(port:0, extra:solaris_get_report());
	exit(0); 
} 
