#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(22992);
 script_version ("$Revision: 1.8 $");
 name["english"] = "Solaris 10 (i386) : 119901-04";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is missing Sun Security Patch number 119901-04
(GNOME 2.6.0_x86: Gnome libtiff - library for reading and writing TIFF Patch).

Date this patch was last updated by Sun : Tue Nov 27 10:16:33 MST 2007

You should install this patch for your system to be up-to-date.

Solution : http://sunsolve.sun.com/search/document.do?assetkey=1-21-119901-04-1
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for patch 119901-04"; 
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Solaris Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Solaris/showrev");
 exit(0);
}



include("solaris.inc");

e +=  solaris_check_patch(release:"5.10_x86", arch:"i386", patch:"119901-04", obsoleted_by:"", package:"SUNWPython", version:"2.3.3,REV=10.0.3.2004.12.16.14.40");
e +=  solaris_check_patch(release:"5.10_x86", arch:"i386", patch:"119901-04", obsoleted_by:"", package:"SUNWTiff", version:"20.2.6.0,REV=10.0.3.2004.12.16.14.41");
e +=  solaris_check_patch(release:"5.10_x86", arch:"i386", patch:"119901-04", obsoleted_by:"", package:"SUNWTiff-devel", version:"20.2.6.0,REV=10.0.3.2004.12.16.14.41");
e +=  solaris_check_patch(release:"5.10_x86", arch:"i386", patch:"119901-04", obsoleted_by:"", package:"SUNWgnome-img-viewer-share", version:"2.6.0,REV=10.0.3.2004.12.16.19.00");
if ( e < 0 ) { 
	if ( NASL_LEVEL < 3000 ) 
	   security_hole(0);
	else  
	   security_hole(port:0, extra:solaris_get_report());
	exit(0); 
} 
