#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12704);
 script_version ("$Revision: 1.11 $");
 script_bugtraq_id(4631);
 script_cve_id("CVE-2002-0084");
 name["english"] = "Solaris 2.5.1 (sparc) : 104849-09";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is missing Sun Security Patch number 104849-09
(SunOS 5.5.1: /kernel/fs/cachefs patch).

Date this patch was last updated by Sun : Tue Apr 01 11:42:17 MST 2003

You should install this patch for your system to be up-to-date.

Solution : http://sunsolve.sun.com/search/document.do?assetkey=1-21-104849-09-1
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for patch 104849-09"; 
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Solaris Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Solaris/showrev");
 exit(0);
}



include("solaris.inc");

e +=  solaris_check_patch(release:"5.5.1", arch:"sparc", patch:"104849-09", obsoleted_by:"", package:"SUNWcsr", version:"11.5.1,REV=96.05.02.21.09");
e +=  solaris_check_patch(release:"5.5.1", arch:"sparc", patch:"104849-09", obsoleted_by:"", package:"SUNWcsu", version:"11.5.1,REV=96.05.02.21.09");
e +=  solaris_check_patch(release:"5.5.1", arch:"sparc", patch:"104849-09", obsoleted_by:"", package:"SUNWhea", version:"11.5.1,REV=96.05.02.21.09");
if ( e < 0 ) { 
	if ( NASL_LEVEL < 3000 ) 
	   security_hole(0);
	else  
	   security_hole(port:0, extra:solaris_get_report());
	exit(0); 
} 
else 
{
	set_kb_item(name:"CVE-2002-0084", value:TRUE);
	set_kb_item(name:"BID-4631", value:TRUE);
}
