#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12826);
 script_version ("$Revision: 1.8 $");
 name["english"] = "Solaris 2.5.1 (i386) : 105963-05";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is missing Sun Security Patch number 105963-05
(SunOS 5.5.1_x86: vi/ex/edit/view/vedit patch).

Date this patch was last updated by Sun : Wed Sep 05 16:28:01 MDT 2001

You should install this patch for your system to be up-to-date.

Solution : http://sunsolve.sun.com/search/document.do?assetkey=1-21-105963-05-1
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for patch 105963-05"; 
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Solaris Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Solaris/showrev");
 exit(0);
}



include("solaris.inc");

e +=  solaris_check_patch(release:"5.5.1_x86", arch:"i386", patch:"105963-05", obsoleted_by:"", package:"SUNWcsu", version:"11.5.1,REV=96.05.02.19.23");
e +=  solaris_check_patch(release:"5.5.1_x86", arch:"i386", patch:"105963-05", obsoleted_by:"", package:"SUNWxcu4", version:"11.5.1,REV=96.05.02.19.23");
if ( e < 0 ) { 
	if ( NASL_LEVEL < 3000 ) 
	   security_hole(0);
	else  
	   security_hole(port:0, extra:solaris_get_report());
	exit(0); 
} 
