#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12863);
 script_version ("$Revision: 1.12 $");
 script_bugtraq_id(5161, 6309, 6535, 8314, 8831, 9962);
 name["english"] = "Solaris 2.6 (sparc) : 105181-39";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is missing Sun Security Patch number 105181-39
(SunOS 5.6: Kernel update patch).

Date this patch was last updated by Sun : Wed Mar 31 10:46:24 MST 2004

You should install this patch for your system to be up-to-date.

Solution : http://sunsolve.sun.com/search/document.do?assetkey=1-21-105181-39-1
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for patch 105181-39"; 
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Solaris Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Solaris/showrev");
 exit(0);
}



include("solaris.inc");

e +=  solaris_check_patch(release:"5.6", arch:"sparc", patch:"105181-39", obsoleted_by:"106629-23", package:"FJSVhea", version:"1.0,REV=1998.09.24.13.46");
e +=  solaris_check_patch(release:"5.6", arch:"sparc", patch:"105181-39", obsoleted_by:"106629-23", package:"SUNWarc", version:"11.6.0,REV=1997.07.15.21.46");
e +=  solaris_check_patch(release:"5.6", arch:"sparc", patch:"105181-39", obsoleted_by:"106629-23", package:"SUNWcsd", version:"11.6.0,REV=1997.07.15.21.46");
e +=  solaris_check_patch(release:"5.6", arch:"sparc", patch:"105181-39", obsoleted_by:"106629-23", package:"SUNWcsr", version:"11.6.0,REV=1997.07.15.21.46");
e +=  solaris_check_patch(release:"5.6", arch:"sparc", patch:"105181-39", obsoleted_by:"106629-23", package:"SUNWcsu", version:"11.6.0,REV=1997.07.15.21.46");
e +=  solaris_check_patch(release:"5.6", arch:"sparc", patch:"105181-39", obsoleted_by:"106629-23", package:"SUNWhea", version:"11.6.0,REV=1997.07.15.21.46");
e +=  solaris_check_patch(release:"5.6", arch:"sparc", patch:"105181-39", obsoleted_by:"106629-23", package:"SUNWhmd", version:"11.6.0,REV=1997.07.15.21.46");
e +=  solaris_check_patch(release:"5.6", arch:"sparc", patch:"105181-39", obsoleted_by:"106629-23", package:"SUNWhmdu", version:"11.6.0,REV=1997.07.15.21.46");
e +=  solaris_check_patch(release:"5.6", arch:"sparc", patch:"105181-39", obsoleted_by:"106629-23", package:"SUNWnisu", version:"11.6.0,REV=1997.07.15.21.46");
e +=  solaris_check_patch(release:"5.6", arch:"sparc", patch:"105181-39", obsoleted_by:"106629-23", package:"SUNWsrh", version:"11.6.0,REV=1997.07.15.21.46");
e +=  solaris_check_patch(release:"5.6", arch:"sparc", patch:"105181-39", obsoleted_by:"106629-23", package:"SUNWssadv", version:"11.6.0,REV=1997.07.15.21.46");
e +=  solaris_check_patch(release:"5.6", arch:"sparc", patch:"105181-39", obsoleted_by:"106629-23", package:"SUNWssaop", version:"11.6.0,REV=1997.07.15.21.46");
if ( e < 0 ) { 
	if ( NASL_LEVEL < 3000 ) 
	   security_hole(0);
	else  
	   security_hole(port:0, extra:solaris_get_report());
	exit(0); 
} 
else 
{
	set_kb_item(name:"BID-5161", value:TRUE);
	set_kb_item(name:"BID-6309", value:TRUE);
	set_kb_item(name:"BID-6535", value:TRUE);
	set_kb_item(name:"BID-8314", value:TRUE);
	set_kb_item(name:"BID-8831", value:TRUE);
	set_kb_item(name:"BID-9962", value:TRUE);
}
