#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12881);
 script_version ("$Revision: 1.9 $");
 script_bugtraq_id(4408);
 name["english"] = "Solaris 2.6 (sparc) : 105633-64";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is missing Sun Security Patch number 105633-64
(OpenWindows 3.6: Xsun patch).

Date this patch was last updated by Sun : Tue Nov 25 10:20:10 MST 2003

You should install this patch for your system to be up-to-date.

Solution : http://sunsolve.sun.com/search/document.do?assetkey=1-21-105633-64-1
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for patch 105633-64"; 
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Solaris Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Solaris/showrev");
 exit(0);
}



include("solaris.inc");

e +=  solaris_check_patch(release:"5.6", arch:"sparc", patch:"105633-64", obsoleted_by:"", package:"SUNWxwcft", version:"3.6.370,REV=0.97.06.19");
e +=  solaris_check_patch(release:"5.6", arch:"sparc", patch:"105633-64", obsoleted_by:"", package:"SUNWxwfnt", version:"3.6.370,REV=0.97.06.19");
e +=  solaris_check_patch(release:"5.6", arch:"sparc", patch:"105633-64", obsoleted_by:"", package:"SUNWxwice", version:"3.6.370,REV=0.97.06.19");
e +=  solaris_check_patch(release:"5.6", arch:"sparc", patch:"105633-64", obsoleted_by:"", package:"SUNWxwinc", version:"3.6.370,REV=0.97.06.19");
e +=  solaris_check_patch(release:"5.6", arch:"sparc", patch:"105633-64", obsoleted_by:"", package:"SUNWxwplt", version:"3.6.370,REV=0.97.07.09");
e +=  solaris_check_patch(release:"5.6", arch:"sparc", patch:"105633-64", obsoleted_by:"", package:"SUNWxwslb", version:"3.6.310,REV=0.97.03.26");
if ( e < 0 ) { 
	if ( NASL_LEVEL < 3000 ) 
	   security_hole(0);
	else  
	   security_hole(port:0, extra:solaris_get_report());
	exit(0); 
} 
else 
{
	set_kb_item(name:"BID-4408", value:TRUE);
}
