#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12896);
 script_version ("$Revision: 1.10 $");
 script_bugtraq_id(294, 7240);
 script_cve_id("CVE-1999-1025", "CVE-2003-0092");
 name["english"] = "Solaris 2.6 (sparc) : 106027-12";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is missing Sun Security Patch number 106027-12
(CDE 1.2 / SDE 1.0: dtsession patch).

Date this patch was last updated by Sun : Thu Apr 10 13:02:22 MDT 2003

You should install this patch for your system to be up-to-date.

Solution : http://sunsolve.sun.com/search/document.do?assetkey=1-21-106027-12-1
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for patch 106027-12"; 
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Solaris Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Solaris/showrev");
 exit(0);
}



include("solaris.inc");

e +=  solaris_check_patch(release:"5.6", arch:"sparc", patch:"106027-12", obsoleted_by:"", package:"SUNWdtma", version:"1.2,REV=10.97.06.27");
e +=  solaris_check_patch(release:"5.6", arch:"sparc", patch:"106027-12", obsoleted_by:"", package:"SUNWdtwm", version:"1.2,REV=10.97.07.08");
if ( e < 0 ) { 
	if ( NASL_LEVEL < 3000 ) 
	   security_hole(0);
	else  
	   security_hole(port:0, extra:solaris_get_report());
	exit(0); 
} 
else 
{
	set_kb_item(name:"CVE-1999-1025", value:TRUE);
	set_kb_item(name:"CVE-2003-0092", value:TRUE);
	set_kb_item(name:"BID-294", value:TRUE);
	set_kb_item(name:"BID-7240", value:TRUE);
}
